/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.PrintWriter;
import java.io.Writer;
import org.apache.tomcat.util.security.Escape;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    private final PrintWriter out;

    public DOMWriter(Writer writer) {
        this.out = new PrintWriter(writer);
    }

    public void print(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this.print(((Document)node).getDocumentElement());
                this.out.flush();
                break;
            }
            case 1: {
                this.out.print('<');
                this.out.print(node.getLocalName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                for (int i2 = 0; i2 < attrs.length; ++i2) {
                    Attr attr = attrs[i2];
                    this.out.print(' ');
                    this.out.print(attr.getLocalName());
                    this.out.print("=\"");
                    this.out.print(Escape.xml("", true, attr.getNodeValue()));
                    this.out.print('\"');
                }
                this.out.print('>');
                this.printChildren(node);
                break;
            }
            case 5: {
                this.printChildren(node);
                break;
            }
            case 4: {
                this.out.print(Escape.xml("", true, node.getNodeValue()));
                break;
            }
            case 3: {
                this.out.print(Escape.xml("", true, node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getLocalName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.out.print(' ');
                    this.out.print(data);
                }
                this.out.print("?>");
            }
        }
        if (type == 1) {
            this.out.print("</");
            this.out.print(node.getLocalName());
            this.out.print('>');
        }
        this.out.flush();
    }

    private void printChildren(Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            for (int i2 = 0; i2 < len; ++i2) {
                this.print(children.item(i2));
            }
        }
    }

    private Attr[] sortAttributes(NamedNodeMap attrs) {
        int i2;
        if (attrs == null) {
            return new Attr[0];
        }
        int len = attrs.getLength();
        Attr[] array = new Attr[len];
        for (i2 = 0; i2 < len; ++i2) {
            array[i2] = (Attr)attrs.item(i2);
        }
        for (i2 = 0; i2 < len - 1; ++i2) {
            String name = null;
            name = array[i2].getLocalName();
            int index = i2;
            for (int j = i2 + 1; j < len; ++j) {
                String curName = null;
                curName = array[j].getLocalName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j;
            }
            if (index == i2) continue;
            Attr temp = array[i2];
            array[i2] = array[index];
            array[index] = temp;
        }
        return array;
    }
}

