/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.pubsub;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ReplayOutput;
import io.lettuce.core.protocol.CommandHandler;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.pubsub.PubSubEndpoint;
import io.lettuce.core.pubsub.PubSubOutput;
import io.lettuce.core.resource.ClientResources;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;

public class PubSubCommandHandler<K, V>
extends CommandHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PubSubCommandHandler.class);
    private final PubSubEndpoint<K, V> endpoint;
    private final RedisCodec<K, V> codec;
    private final Deque<ReplayOutput<K, V>> queue = new ArrayDeque<ReplayOutput<K, V>>();
    private ResponseHeaderReplayOutput<K, V> replay;
    private PubSubOutput<K, V, V> output;

    public PubSubCommandHandler(ClientOptions clientOptions, ClientResources clientResources, RedisCodec<K, V> codec, PubSubEndpoint<K, V> endpoint) {
        super(clientOptions, clientResources, endpoint);
        this.endpoint = endpoint;
        this.codec = codec;
        this.output = new PubSubOutput(codec);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.replay = null;
        this.queue.clear();
        super.channelInactive(ctx);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer) throws InterruptedException {
        ReplayOutput<K, V> replay;
        if (this.output.type() != null && !this.output.isCompleted()) {
            if (!super.decode(buffer, this.output)) {
                return;
            }
            RedisCommand<?, ?, ?> peek = this.getStack().peek();
            this.canComplete(peek);
            this.doNotifyMessage(this.output);
            this.output = new PubSubOutput(this.codec);
        }
        if (!this.getStack().isEmpty()) {
            super.decode(ctx, buffer);
        }
        while ((replay = this.queue.poll()) != null) {
            replay.replay(this.output);
            this.doNotifyMessage(this.output);
            this.output = new PubSubOutput(this.codec);
        }
        while (super.getStack().isEmpty() && buffer.isReadable()) {
            if (!super.decode(buffer, this.output)) {
                return;
            }
            this.doNotifyMessage(this.output);
            this.output = new PubSubOutput(this.codec);
        }
        buffer.discardReadBytes();
    }

    @Override
    protected boolean canDecode(ByteBuf buffer) {
        return super.canDecode(buffer) && this.output.type() == null;
    }

    @Override
    protected boolean canComplete(RedisCommand<?, ?, ?> command) {
        if (PubSubCommandHandler.isPubSubMessage(this.replay)) {
            this.queue.add(this.replay);
            this.replay = null;
            return false;
        }
        return super.canComplete(command);
    }

    @Override
    protected void complete(RedisCommand<?, ?, ?> command) {
        if (this.replay != null && command.getOutput() != null) {
            try {
                this.replay.replay(command.getOutput());
            }
            catch (Exception e) {
                command.completeExceptionally(e);
            }
            this.replay = null;
        }
        super.complete(command);
    }

    private static boolean isPubSubMessage(ResponseHeaderReplayOutput<?, ?> replay) {
        if (replay == null) {
            return false;
        }
        String firstElement = replay.firstElement;
        if (replay.multiCount != null && firstElement != null) {
            if (replay.multiCount == 3 && firstElement.equalsIgnoreCase(PubSubOutput.Type.message.name())) {
                return true;
            }
            if (replay.multiCount == 4 && firstElement.equalsIgnoreCase(PubSubOutput.Type.pmessage.name())) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected CommandOutput<?, ?, ?> getCommandOutput(RedisCommand<?, ?, ?> command) {
        if (this.getStack().isEmpty() || command.getOutput() == null) {
            return super.getCommandOutput(command);
        }
        if (this.replay == null) {
            this.replay = new ResponseHeaderReplayOutput();
        }
        return this.replay;
    }

    @Override
    protected void afterDecode(ChannelHandlerContext ctx, RedisCommand<?, ?, ?> command) {
        if (command.getOutput() instanceof PubSubOutput) {
            this.doNotifyMessage((PubSubOutput)command.getOutput());
        }
    }

    private void doNotifyMessage(PubSubOutput<K, V, V> output) {
        try {
            this.endpoint.notifyMessage(output);
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred in PubSubEndpoint.notifyMessage", e);
        }
    }

    static class ResponseHeaderReplayOutput<K, V>
    extends ReplayOutput<K, V> {
        Integer multiCount;
        String firstElement;

        ResponseHeaderReplayOutput() {
        }

        @Override
        public void set(ByteBuffer bytes) {
            if (this.firstElement == null && bytes != null && bytes.remaining() > 0) {
                bytes.mark();
                this.firstElement = StringCodec.ASCII.decodeKey(bytes);
                bytes.reset();
            }
            super.set(bytes);
        }

        @Override
        public void multi(int count) {
            if (this.multiCount == null) {
                this.multiCount = count;
            }
            super.multi(count);
        }
    }
}

