/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.LettuceStrings;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.codec.ToByteBufEncoder;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgsAccessor;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.LettuceCharsets;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public class CommandArgs<K, V> {
    static final byte[] CRLF = "\r\n".getBytes(LettuceCharsets.ASCII);
    protected final RedisCodec<K, V> codec;
    final List<SingularArgument> singularArguments = new ArrayList<SingularArgument>(10);

    public CommandArgs(RedisCodec<K, V> codec) {
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
        this.codec = codec;
    }

    public int count() {
        return this.singularArguments.size();
    }

    public CommandArgs<K, V> addKey(K key) {
        this.singularArguments.add(KeyArgument.of(key, this.codec));
        return this;
    }

    public CommandArgs<K, V> addKeys(Iterable<K> keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        for (K key : keys) {
            this.addKey(key);
        }
        return this;
    }

    @SafeVarargs
    public final CommandArgs<K, V> addKeys(K ... keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        for (K key : keys) {
            this.addKey(key);
        }
        return this;
    }

    public CommandArgs<K, V> addValue(V value) {
        this.singularArguments.add(ValueArgument.of(value, this.codec));
        return this;
    }

    public CommandArgs<K, V> addValues(Iterable<V> values) {
        LettuceAssert.notNull(values, "Values must not be null");
        for (V value : values) {
            this.addValue(value);
        }
        return this;
    }

    @SafeVarargs
    public final CommandArgs<K, V> addValues(V ... values) {
        LettuceAssert.notNull(values, "Values must not be null");
        for (V value : values) {
            this.addValue(value);
        }
        return this;
    }

    public CommandArgs<K, V> add(Map<K, V> map) {
        LettuceAssert.notNull(map, "Map must not be null");
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.addKey(entry.getKey()).addValue(entry.getValue());
        }
        return this;
    }

    public CommandArgs<K, V> add(String s) {
        this.singularArguments.add(StringArgument.of(s));
        return this;
    }

    public CommandArgs<K, V> add(char[] cs) {
        this.singularArguments.add(CharArrayArgument.of(cs));
        return this;
    }

    public CommandArgs<K, V> add(long n) {
        this.singularArguments.add(IntegerArgument.of(n));
        return this;
    }

    public CommandArgs<K, V> add(double n) {
        this.singularArguments.add(DoubleArgument.of(n));
        return this;
    }

    public CommandArgs<K, V> add(byte[] value) {
        this.singularArguments.add(BytesArgument.of(value));
        return this;
    }

    public CommandArgs<K, V> add(CommandKeyword keyword) {
        LettuceAssert.notNull((Object)keyword, "CommandKeyword must not be null");
        this.singularArguments.add(ProtocolKeywordArgument.of(keyword));
        return this;
    }

    public CommandArgs<K, V> add(CommandType type) {
        LettuceAssert.notNull((Object)type, "CommandType must not be null");
        this.singularArguments.add(ProtocolKeywordArgument.of(type));
        return this;
    }

    public CommandArgs<K, V> add(ProtocolKeyword keyword) {
        LettuceAssert.notNull((Object)keyword, "CommandKeyword must not be null");
        this.singularArguments.add(ProtocolKeywordArgument.of(keyword));
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        ByteBuf buffer = UnpooledByteBufAllocator.DEFAULT.buffer(this.singularArguments.size() * 10);
        this.encode(buffer);
        buffer.resetReaderIndex();
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        sb.append(" [buffer=").append(new String(bytes));
        sb.append(']');
        buffer.release();
        return sb.toString();
    }

    public String toCommandString() {
        return LettuceStrings.collectionToDelimitedString(this.singularArguments, " ", "", "");
    }

    @Deprecated
    public Long getFirstInteger() {
        return CommandArgsAccessor.getFirstInteger(this);
    }

    @Deprecated
    public String getFirstString() {
        return CommandArgsAccessor.getFirstString(this);
    }

    public ByteBuffer getFirstEncodedKey() {
        return CommandArgsAccessor.encodeFirstKey(this);
    }

    public void encode(ByteBuf buf) {
        buf.touch("CommandArgs.encode(\u2026)");
        for (SingularArgument singularArgument : this.singularArguments) {
            singularArgument.encode(buf);
        }
    }

    static class ValueArgument<K, V>
    extends SingularArgument {
        final V val;
        final RedisCodec<K, V> codec;

        private ValueArgument(V val, RedisCodec<K, V> codec) {
            this.val = val;
            this.codec = codec;
        }

        static <K, V> ValueArgument<K, V> of(V val, RedisCodec<K, V> codec) {
            return new ValueArgument<K, V>(val, codec);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void encode(ByteBuf target) {
            if (this.codec instanceof ToByteBufEncoder) {
                ToByteBufEncoder toByteBufEncoder = (ToByteBufEncoder)((Object)this.codec);
                ByteBuf temporaryBuffer = target.alloc().buffer(toByteBufEncoder.estimateSize(this.val) + 6);
                try {
                    toByteBufEncoder.encodeValue(this.val, temporaryBuffer);
                    ByteBufferArgument.writeByteBuf(target, temporaryBuffer);
                }
                finally {
                    temporaryBuffer.release();
                }
                return;
            }
            ByteBufferArgument.writeByteBuffer(target, this.codec.encodeValue(this.val));
        }

        public String toString() {
            return String.format("value<%s>", new StringCodec().decodeValue(this.codec.encodeValue(this.val)));
        }
    }

    static class KeyArgument<K, V>
    extends SingularArgument {
        final K key;
        final RedisCodec<K, V> codec;

        private KeyArgument(K key, RedisCodec<K, V> codec) {
            this.key = key;
            this.codec = codec;
        }

        static <K, V> KeyArgument<K, V> of(K key, RedisCodec<K, V> codec) {
            return new KeyArgument<K, V>(key, codec);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void encode(ByteBuf target) {
            if (this.codec instanceof ToByteBufEncoder) {
                ToByteBufEncoder toByteBufEncoder = (ToByteBufEncoder)((Object)this.codec);
                ByteBuf temporaryBuffer = target.alloc().buffer(toByteBufEncoder.estimateSize(this.key) + 6);
                try {
                    toByteBufEncoder.encodeKey(this.key, temporaryBuffer);
                    ByteBufferArgument.writeByteBuf(target, temporaryBuffer);
                }
                finally {
                    temporaryBuffer.release();
                }
                return;
            }
            ByteBufferArgument.writeByteBuffer(target, this.codec.encodeKey(this.key));
        }

        public String toString() {
            return String.format("key<%s>", new StringCodec().decodeKey(this.codec.encodeKey(this.key)));
        }
    }

    static class CharArrayArgument
    extends SingularArgument {
        final char[] val;

        private CharArrayArgument(char[] val) {
            this.val = val;
        }

        static CharArrayArgument of(char[] val) {
            return new CharArrayArgument(val);
        }

        @Override
        void encode(ByteBuf target) {
            CharArrayArgument.writeString(target, this.val);
        }

        static void writeString(ByteBuf target, char[] value) {
            target.writeByte(36);
            IntegerArgument.writeInteger(target, value.length);
            target.writeBytes(CRLF);
            for (int i2 = 0; i2 < value.length; ++i2) {
                target.writeByte((byte)value[i2]);
            }
            target.writeBytes(CRLF);
        }

        public String toString() {
            return new String(this.val);
        }
    }

    static class StringArgument
    extends SingularArgument {
        final String val;

        private StringArgument(String val) {
            this.val = val;
        }

        static StringArgument of(String val) {
            return new StringArgument(val);
        }

        @Override
        void encode(ByteBuf target) {
            StringArgument.writeString(target, this.val);
        }

        static void writeString(ByteBuf target, String value) {
            target.writeByte(36);
            IntegerArgument.writeInteger(target, value.length());
            target.writeBytes(CRLF);
            for (int i2 = 0; i2 < value.length(); ++i2) {
                target.writeByte((byte)value.charAt(i2));
            }
            target.writeBytes(CRLF);
        }

        public String toString() {
            return this.val;
        }
    }

    static class DoubleArgument
    extends SingularArgument {
        final double val;

        private DoubleArgument(double val) {
            this.val = val;
        }

        static DoubleArgument of(double val) {
            return new DoubleArgument(val);
        }

        @Override
        void encode(ByteBuf target) {
            StringArgument.writeString(target, Double.toString(this.val));
        }

        public String toString() {
            return "" + this.val;
        }
    }

    static class IntegerCache {
        static final IntegerArgument[] cache;
        static final IntegerArgument[] negativeCache;

        IntegerCache() {
        }

        static {
            int high = Integer.getInteger("io.lettuce.core.CommandArgs.IntegerCache", 128);
            cache = new IntegerArgument[high];
            negativeCache = new IntegerArgument[high];
            for (int i2 = 0; i2 < high; ++i2) {
                IntegerCache.cache[i2] = new IntegerArgument(i2);
                IntegerCache.negativeCache[i2] = new IntegerArgument(-i2);
            }
        }
    }

    static class IntegerArgument
    extends SingularArgument {
        final long val;

        private IntegerArgument(long val) {
            this.val = val;
        }

        static IntegerArgument of(long val) {
            if (val >= 0L && val < (long)IntegerCache.cache.length) {
                return IntegerCache.cache[(int)val];
            }
            if (val < 0L && -val < (long)IntegerCache.cache.length) {
                return IntegerCache.negativeCache[(int)(-val)];
            }
            return new IntegerArgument(val);
        }

        @Override
        void encode(ByteBuf target) {
            StringArgument.writeString(target, Long.toString(this.val));
        }

        public String toString() {
            return "" + this.val;
        }

        static void writeInteger(ByteBuf target, long value) {
            if (value < 10L) {
                target.writeByte((byte)(48L + value));
                return;
            }
            String asString = Long.toString(value);
            for (int i2 = 0; i2 < asString.length(); ++i2) {
                target.writeByte((byte)asString.charAt(i2));
            }
        }
    }

    static class ByteBufferArgument {
        ByteBufferArgument() {
        }

        static void writeByteBuffer(ByteBuf target, ByteBuffer value) {
            target.writeByte(36);
            IntegerArgument.writeInteger(target, value.remaining());
            target.writeBytes(CRLF);
            target.writeBytes(value);
            target.writeBytes(CRLF);
        }

        static void writeByteBuf(ByteBuf target, ByteBuf value) {
            target.writeByte(36);
            IntegerArgument.writeInteger(target, value.readableBytes());
            target.writeBytes(CRLF);
            target.writeBytes(value);
            target.writeBytes(CRLF);
        }
    }

    static class CommandKeywordCache {
        static final ProtocolKeywordArgument[] cache;

        CommandKeywordCache() {
        }

        static {
            CommandKeyword[] values = CommandKeyword.values();
            cache = new ProtocolKeywordArgument[values.length];
            for (int i2 = 0; i2 < cache.length; ++i2) {
                CommandKeywordCache.cache[i2] = new ProtocolKeywordArgument(values[i2]);
            }
        }
    }

    static class CommandTypeCache {
        static final ProtocolKeywordArgument[] cache;

        CommandTypeCache() {
        }

        static {
            CommandType[] values = CommandType.values();
            cache = new ProtocolKeywordArgument[values.length];
            for (int i2 = 0; i2 < cache.length; ++i2) {
                CommandTypeCache.cache[i2] = new ProtocolKeywordArgument(values[i2]);
            }
        }
    }

    static class ProtocolKeywordArgument
    extends BytesArgument {
        private final ProtocolKeyword protocolKeyword;

        private ProtocolKeywordArgument(ProtocolKeyword protocolKeyword) {
            super(protocolKeyword.getBytes());
            this.protocolKeyword = protocolKeyword;
        }

        static BytesArgument of(ProtocolKeyword protocolKeyword) {
            if (protocolKeyword instanceof CommandType) {
                return CommandTypeCache.cache[((Enum)((Object)protocolKeyword)).ordinal()];
            }
            if (protocolKeyword instanceof CommandKeyword) {
                return CommandKeywordCache.cache[((Enum)((Object)protocolKeyword)).ordinal()];
            }
            return ProtocolKeywordArgument.of(protocolKeyword.getBytes());
        }

        @Override
        public String toString() {
            return this.protocolKeyword.name();
        }
    }

    static class BytesArgument
    extends SingularArgument {
        final byte[] val;

        private BytesArgument(byte[] val) {
            this.val = val;
        }

        static BytesArgument of(byte[] val) {
            return new BytesArgument(val);
        }

        @Override
        void encode(ByteBuf buffer) {
            BytesArgument.writeBytes(buffer, this.val);
        }

        static void writeBytes(ByteBuf buffer, byte[] value) {
            buffer.writeByte(36);
            IntegerArgument.writeInteger(buffer, value.length);
            buffer.writeBytes(CRLF);
            buffer.writeBytes(value);
            buffer.writeBytes(CRLF);
        }

        public String toString() {
            return Base64.getEncoder().encodeToString(this.val);
        }
    }

    static abstract class SingularArgument {
        SingularArgument() {
        }

        abstract void encode(ByteBuf var1);
    }
}

