/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster.api.sync;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.KeyValue;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.StreamScanCursor;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.sync.NodeSelection;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.output.KeyStreamingChannel;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public interface RedisAdvancedClusterCommands<K, V>
extends RedisClusterCommands<K, V> {
    public RedisClusterCommands<K, V> getConnection(String var1);

    public RedisClusterCommands<K, V> getConnection(String var1, int var2);

    public StatefulRedisClusterConnection<K, V> getStatefulConnection();

    default public NodeSelection<K, V> masters() {
        return this.nodes(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.MASTER));
    }

    @Deprecated
    default public NodeSelection<K, V> slaves() {
        return this.readonly(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE));
    }

    @Deprecated
    default public NodeSelection<K, V> slaves(Predicate<RedisClusterNode> predicate) {
        return this.readonly(redisClusterNode -> predicate.test((RedisClusterNode)redisClusterNode) && redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE));
    }

    default public NodeSelection<K, V> replicas() {
        return this.readonly(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.REPLICA));
    }

    default public NodeSelection<K, V> replicas(Predicate<RedisClusterNode> predicate) {
        return this.readonly(redisClusterNode -> predicate.test((RedisClusterNode)redisClusterNode) && redisClusterNode.is(RedisClusterNode.NodeFlag.REPLICA));
    }

    default public NodeSelection<K, V> all() {
        return this.nodes(redisClusterNode -> true);
    }

    public NodeSelection<K, V> readonly(Predicate<RedisClusterNode> var1);

    public NodeSelection<K, V> nodes(Predicate<RedisClusterNode> var1);

    public NodeSelection<K, V> nodes(Predicate<RedisClusterNode> var1, boolean var2);

    @Override
    public Long del(K ... var1);

    @Override
    public Long unlink(K ... var1);

    @Override
    public Long exists(K ... var1);

    @Override
    public List<KeyValue<K, V>> mget(K ... var1);

    @Override
    public String mset(Map<K, V> var1);

    @Override
    public Boolean msetnx(Map<K, V> var1);

    @Override
    public String clientSetname(K var1);

    @Override
    public String flushall();

    @Override
    public String flushdb();

    @Override
    public Long dbsize();

    @Override
    public List<K> keys(K var1);

    @Override
    public Long keys(KeyStreamingChannel<K> var1, K var2);

    @Override
    public V randomkey();

    @Override
    public String scriptFlush();

    @Override
    public String scriptKill();

    @Override
    public void shutdown(boolean var1);

    @Override
    public KeyScanCursor<K> scan();

    @Override
    public KeyScanCursor<K> scan(ScanArgs var1);

    @Override
    public KeyScanCursor<K> scan(ScanCursor var1, ScanArgs var2);

    @Override
    public KeyScanCursor<K> scan(ScanCursor var1);

    @Override
    public StreamScanCursor scan(KeyStreamingChannel<K> var1);

    @Override
    public StreamScanCursor scan(KeyStreamingChannel<K> var1, ScanArgs var2);

    @Override
    public StreamScanCursor scan(KeyStreamingChannel<K> var1, ScanCursor var2, ScanArgs var3);

    @Override
    public StreamScanCursor scan(KeyStreamingChannel<K> var1, ScanCursor var2);

    @Override
    public Long touch(K ... var1);
}

