/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.OrderingReadFromAccessor;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.StreamScanCursor;
import io.lettuce.core.cluster.PartitionAccessor;
import io.lettuce.core.cluster.PipelinedRedisFuture;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.models.role.RedisNodeDescription;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import reactor.core.publisher.Mono;

class ClusterScanSupport {
    static final ScanCursorMapper<RedisFuture<KeyScanCursor<?>>> futureKeyScanCursorMapper = new ScanCursorMapper<RedisFuture<KeyScanCursor<?>>>(){

        @Override
        public RedisFuture<KeyScanCursor<?>> map(final List<String> nodeIds, final String currentNodeId, RedisFuture<KeyScanCursor<?>> cursor) {
            return new PipelinedRedisFuture(cursor, new Function<KeyScanCursor<?>, KeyScanCursor<?>>(){

                @Override
                public KeyScanCursor<?> apply(KeyScanCursor<?> result) {
                    return new ClusterKeyScanCursor(nodeIds, currentNodeId, result);
                }
            });
        }
    };
    static final ScanCursorMapper<RedisFuture<StreamScanCursor>> futureStreamScanCursorMapper = new ScanCursorMapper<RedisFuture<StreamScanCursor>>(){

        @Override
        public RedisFuture<StreamScanCursor> map(final List<String> nodeIds, final String currentNodeId, RedisFuture<StreamScanCursor> cursor) {
            return new PipelinedRedisFuture<StreamScanCursor>(cursor, new Function<StreamScanCursor, StreamScanCursor>(){

                @Override
                public StreamScanCursor apply(StreamScanCursor result) {
                    return new ClusterStreamScanCursor(nodeIds, currentNodeId, result);
                }
            });
        }
    };
    static final ScanCursorMapper<Mono<KeyScanCursor<?>>> reactiveKeyScanCursorMapper = (nodeIds, currentNodeId, cursor) -> cursor.map(keyScanCursor -> new ClusterKeyScanCursor(nodeIds, currentNodeId, keyScanCursor));
    static final ScanCursorMapper<Mono<StreamScanCursor>> reactiveStreamScanCursorMapper = (nodeIds, currentNodeId, cursor) -> cursor.map(new Function<StreamScanCursor, StreamScanCursor>(){

        @Override
        public StreamScanCursor apply(StreamScanCursor streamScanCursor) {
            return new ClusterStreamScanCursor(nodeIds, currentNodeId, streamScanCursor);
        }
    });

    ClusterScanSupport() {
    }

    static ScanCursor getContinuationCursor(ScanCursor scanCursor) {
        if (ScanCursor.INITIAL.equals(scanCursor)) {
            return scanCursor;
        }
        ClusterScanSupport.assertClusterScanCursor(scanCursor);
        ClusterScanCursor clusterScanCursor = (ClusterScanCursor)((Object)scanCursor);
        if (clusterScanCursor.isScanOnCurrentNodeFinished()) {
            return ScanCursor.INITIAL;
        }
        return scanCursor;
    }

    static <K, V> List<String> getNodeIds(StatefulRedisClusterConnection<K, V> connection, ScanCursor cursor) {
        if (ScanCursor.INITIAL.equals(cursor)) {
            List<String> nodeIds = ClusterScanSupport.getNodeIds(connection);
            ClusterScanSupport.assertHasNodes(nodeIds);
            return nodeIds;
        }
        ClusterScanSupport.assertClusterScanCursor(cursor);
        ClusterScanCursor clusterScanCursor = (ClusterScanCursor)((Object)cursor);
        return clusterScanCursor.getNodeIds();
    }

    static String getCurrentNodeId(ScanCursor cursor, List<String> nodeIds) {
        if (ScanCursor.INITIAL.equals(cursor)) {
            ClusterScanSupport.assertHasNodes(nodeIds);
            return nodeIds.get(0);
        }
        ClusterScanSupport.assertClusterScanCursor(cursor);
        return ClusterScanSupport.getNodeIdForNextScanIteration(nodeIds, (ClusterScanCursor)((Object)cursor));
    }

    private static List<String> getNodeIds(StatefulRedisClusterConnection<?, ?> connection) {
        ArrayList<String> nodeIds = new ArrayList<String>();
        PartitionAccessor partitionAccessor = new PartitionAccessor(connection.getPartitions());
        for (RedisClusterNode redisClusterNode : partitionAccessor.getMasters()) {
            if (connection.getReadFrom() != null) {
                final List<RedisClusterNode> readCandidates = partitionAccessor.getReadCandidates(redisClusterNode);
                List<RedisNodeDescription> selection = connection.getReadFrom().select(new ReadFrom.Nodes(){

                    @Override
                    public List<RedisNodeDescription> getNodes() {
                        return readCandidates;
                    }

                    @Override
                    public Iterator<RedisNodeDescription> iterator() {
                        return readCandidates.iterator();
                    }
                });
                if (!selection.isEmpty()) {
                    int indexToUse = 0;
                    if (!OrderingReadFromAccessor.isOrderSensitive(connection.getReadFrom())) {
                        indexToUse = ThreadLocalRandom.current().nextInt(selection.size());
                    }
                    RedisClusterNode selectedNode = (RedisClusterNode)selection.get(indexToUse);
                    nodeIds.add(selectedNode.getNodeId());
                    continue;
                }
            }
            nodeIds.add(redisClusterNode.getNodeId());
        }
        return nodeIds;
    }

    private static String getNodeIdForNextScanIteration(List<String> nodeIds, ClusterScanCursor clusterKeyScanCursor) {
        if (clusterKeyScanCursor.isScanOnCurrentNodeFinished()) {
            if (clusterKeyScanCursor.isFinished()) {
                throw new IllegalStateException("Cluster scan is finished");
            }
            int nodeIndex = nodeIds.indexOf(clusterKeyScanCursor.getCurrentNodeId());
            return nodeIds.get(nodeIndex + 1);
        }
        return clusterKeyScanCursor.getCurrentNodeId();
    }

    private static void assertClusterScanCursor(ScanCursor cursor) {
        if (!(cursor instanceof ClusterScanCursor)) {
            throw new IllegalArgumentException("A scan in Redis Cluster mode requires to reuse the resulting cursor from the previous scan invocation");
        }
    }

    private static void assertHasNodes(List<String> nodeIds) {
        if (nodeIds.isEmpty()) {
            throw new RedisException("No available nodes for a scan");
        }
    }

    static <K> ScanCursorMapper<RedisFuture<KeyScanCursor<K>>> asyncClusterKeyScanCursorMapper() {
        return futureKeyScanCursorMapper;
    }

    static ScanCursorMapper<RedisFuture<StreamScanCursor>> asyncClusterStreamScanCursorMapper() {
        return futureStreamScanCursorMapper;
    }

    static <K> ScanCursorMapper<Mono<KeyScanCursor<K>>> reactiveClusterKeyScanCursorMapper() {
        return reactiveKeyScanCursorMapper;
    }

    static ScanCursorMapper<Mono<StreamScanCursor>> reactiveClusterStreamScanCursorMapper() {
        return reactiveStreamScanCursorMapper;
    }

    private static class ClusterStreamScanCursor
    extends StreamScanCursor
    implements ClusterScanCursor {
        final List<String> nodeIds;
        final String currentNodeId;
        final StreamScanCursor cursor;

        public ClusterStreamScanCursor(List<String> nodeIds, String currentNodeId, StreamScanCursor cursor) {
            int nodeIndex;
            this.nodeIds = nodeIds;
            this.currentNodeId = currentNodeId;
            this.cursor = cursor;
            this.setCursor(cursor.getCursor());
            this.setCount(cursor.getCount());
            if (cursor.isFinished() && ((nodeIndex = nodeIds.indexOf(currentNodeId)) == -1 || nodeIndex == nodeIds.size() - 1)) {
                this.setFinished(true);
            }
        }

        @Override
        public List<String> getNodeIds() {
            return this.nodeIds;
        }

        @Override
        public String getCurrentNodeId() {
            return this.currentNodeId;
        }

        @Override
        public boolean isScanOnCurrentNodeFinished() {
            return this.cursor.isFinished();
        }
    }

    private static class ClusterKeyScanCursor<K>
    extends KeyScanCursor<K>
    implements ClusterScanCursor {
        final List<String> nodeIds;
        final String currentNodeId;
        final KeyScanCursor<K> cursor;

        public ClusterKeyScanCursor(List<String> nodeIds, String currentNodeId, KeyScanCursor<K> cursor) {
            int nodeIndex;
            this.nodeIds = nodeIds;
            this.currentNodeId = currentNodeId;
            this.cursor = cursor;
            this.setCursor(cursor.getCursor());
            this.getKeys().addAll(cursor.getKeys());
            if (cursor.isFinished() && ((nodeIndex = nodeIds.indexOf(currentNodeId)) == -1 || nodeIndex == nodeIds.size() - 1)) {
                this.setFinished(true);
            }
        }

        @Override
        public List<String> getNodeIds() {
            return this.nodeIds;
        }

        @Override
        public String getCurrentNodeId() {
            return this.currentNodeId;
        }

        @Override
        public boolean isScanOnCurrentNodeFinished() {
            return this.cursor.isFinished();
        }
    }

    static interface ClusterScanCursor {
        public List<String> getNodeIds();

        public String getCurrentNodeId();

        public boolean isScanOnCurrentNodeFinished();

        public boolean isFinished();
    }

    static interface ScanCursorMapper<T> {
        public T map(List<String> var1, String var2, T var3);
    }
}

