/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.ConnectionFuture;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.ClusterConnectionProvider;
import io.lettuce.core.cluster.models.partitions.Partitions;
import java.util.function.Function;

interface ClusterNodeConnectionFactory<K, V>
extends Function<ConnectionKey, ConnectionFuture<StatefulRedisConnection<K, V>>> {
    public void setPartitions(Partitions var1);

    public static class ConnectionKey {
        final ClusterConnectionProvider.Intent intent;
        final String nodeId;
        final String host;
        final int port;

        public ConnectionKey(ClusterConnectionProvider.Intent intent, String nodeId) {
            this.intent = intent;
            this.nodeId = nodeId;
            this.host = null;
            this.port = 0;
        }

        public ConnectionKey(ClusterConnectionProvider.Intent intent, String host, int port) {
            this.intent = intent;
            this.host = host;
            this.port = port;
            this.nodeId = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConnectionKey)) {
                return false;
            }
            ConnectionKey key = (ConnectionKey)o;
            if (this.port != key.port) {
                return false;
            }
            if (this.intent != key.intent) {
                return false;
            }
            if (this.nodeId != null ? !this.nodeId.equals(key.nodeId) : key.nodeId != null) {
                return false;
            }
            return !(this.host == null ? key.host != null : !this.host.equals(key.host));
        }

        public int hashCode() {
            int result = this.intent != null ? this.intent.name().hashCode() : 0;
            result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
            result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
            result = 31 * result + this.port;
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [intent=").append((Object)this.intent);
            sb.append(", nodeId='").append(this.nodeId).append('\'');
            sb.append(", host='").append(this.host).append('\'');
            sb.append(", port=").append(this.port);
            sb.append(']');
            return sb.toString();
        }
    }
}

