/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.internal.LettuceAssert;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class SocketOptions {
    public static final long DEFAULT_CONNECT_TIMEOUT = 10L;
    public static final TimeUnit DEFAULT_CONNECT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    public static final Duration DEFAULT_CONNECT_TIMEOUT_DURATION = Duration.ofSeconds(10L);
    public static final boolean DEFAULT_SO_KEEPALIVE = false;
    public static final boolean DEFAULT_SO_NO_DELAY = false;
    private final Duration connectTimeout;
    private final boolean keepAlive;
    private final boolean tcpNoDelay;

    protected SocketOptions(Builder builder) {
        this.connectTimeout = builder.connectTimeout;
        this.keepAlive = builder.keepAlive;
        this.tcpNoDelay = builder.tcpNoDelay;
    }

    protected SocketOptions(SocketOptions original) {
        this.connectTimeout = original.getConnectTimeout();
        this.keepAlive = original.isKeepAlive();
        this.tcpNoDelay = original.isTcpNoDelay();
    }

    public static SocketOptions copyOf(SocketOptions options) {
        return new SocketOptions(options);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SocketOptions create() {
        return SocketOptions.builder().build();
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public static class Builder {
        private Duration connectTimeout = DEFAULT_CONNECT_TIMEOUT_DURATION;
        private boolean keepAlive = false;
        private boolean tcpNoDelay = false;

        private Builder() {
        }

        public Builder connectTimeout(Duration connectTimeout) {
            LettuceAssert.notNull((Object)connectTimeout, "Connection timeout must not be null");
            LettuceAssert.isTrue(connectTimeout.toNanos() > 0L, "Connect timeout must be greater 0");
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Deprecated
        public Builder connectTimeout(long connectTimeout, TimeUnit connectTimeoutUnit) {
            LettuceAssert.isTrue(connectTimeout > 0L, "Connect timeout must be greater 0");
            LettuceAssert.notNull((Object)connectTimeoutUnit, "TimeUnit must not be null");
            return this.connectTimeout(Duration.ofNanos(connectTimeoutUnit.toNanos(connectTimeout)));
        }

        public Builder keepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder tcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
            return this;
        }

        public SocketOptions build() {
            return new SocketOptions(this);
        }
    }
}

