/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.net;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.api.selector.ExpressionSelector;
import com.alibaba.nacos.api.selector.SelectorType;
import com.alibaba.nacos.client.config.impl.SpasAdapter;
import com.alibaba.nacos.client.monitor.MetricsMonitor;
import com.alibaba.nacos.client.naming.beat.BeatInfo;
import com.alibaba.nacos.client.naming.net.HttpClient;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.naming.utils.IoUtils;
import com.alibaba.nacos.client.naming.utils.NetUtils;
import com.alibaba.nacos.client.naming.utils.SignUtil;
import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.StringUtils;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.common.util.UuidUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class NamingProxy {
    private static final int DEFAULT_SERVER_PORT = 8848;
    private int serverPort = 8848;
    private String namespaceId;
    private String endpoint;
    private String nacosDomain;
    private List<String> serverList;
    private List<String> serversFromEndpoint = new ArrayList<String>();
    private long lastSrvRefTime = 0L;
    private long vipSrvRefInterMillis = TimeUnit.SECONDS.toMillis(30L);
    private Properties properties;

    public NamingProxy(String namespaceId, String endpoint, String serverList) {
        this.namespaceId = namespaceId;
        this.endpoint = endpoint;
        if (StringUtils.isNotEmpty(serverList)) {
            this.serverList = Arrays.asList(serverList.split(","));
            if (this.serverList.size() == 1) {
                this.nacosDomain = serverList;
            }
        }
        this.initRefreshSrvIfNeed();
    }

    private void initRefreshSrvIfNeed() {
        if (StringUtils.isEmpty(this.endpoint)) {
            return;
        }
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.alibaba.nacos.client.naming.serverlist.updater");
                t.setDaemon(true);
                return t;
            }
        });
        executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                NamingProxy.this.refreshSrvIfNeed();
            }
        }, 0L, this.vipSrvRefInterMillis, TimeUnit.MILLISECONDS);
        this.refreshSrvIfNeed();
    }

    public List<String> getServerListFromEndpoint() {
        try {
            String urlString = "http://" + this.endpoint + "/nacos/serverlist";
            List<String> headers = this.builderHeaders();
            HttpClient.HttpResult result = HttpClient.httpGet(urlString, headers, null, "UTF-8");
            if (200 != result.code) {
                throw new IOException("Error while requesting: " + urlString + "'. Server returned: " + result.code);
            }
            String content = result.content;
            ArrayList<String> list = new ArrayList<String>();
            for (String line : IoUtils.readLines(new StringReader(content))) {
                if (line.trim().isEmpty()) continue;
                list.add(line.trim());
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void refreshSrvIfNeed() {
        try {
            if (!CollectionUtils.isEmpty(this.serverList)) {
                LogUtils.NAMING_LOGGER.debug("server list provided by user: " + this.serverList);
                return;
            }
            if (System.currentTimeMillis() - this.lastSrvRefTime < this.vipSrvRefInterMillis) {
                return;
            }
            List<String> list = this.getServerListFromEndpoint();
            if (CollectionUtils.isEmpty(list)) {
                throw new Exception("Can not acquire Nacos list");
            }
            if (!CollectionUtils.isEqualCollection(list, this.serversFromEndpoint)) {
                LogUtils.NAMING_LOGGER.info("[SERVER-LIST] server list is updated: " + list);
            }
            this.serversFromEndpoint = list;
            this.lastSrvRefTime = System.currentTimeMillis();
        }
        catch (Throwable e) {
            LogUtils.NAMING_LOGGER.warn("failed to update server list", e);
        }
    }

    public void registerService(String serviceName, String groupName, Instance instance) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[REGISTER-SERVICE] {} registering service {} with instance: {}", this.namespaceId, serviceName, instance);
        HashMap<String, String> params = new HashMap<String, String>(9);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", serviceName);
        params.put("groupName", groupName);
        params.put("clusterName", instance.getClusterName());
        params.put("ip", instance.getIp());
        params.put("port", String.valueOf(instance.getPort()));
        params.put("weight", String.valueOf(instance.getWeight()));
        params.put("enable", String.valueOf(instance.isEnabled()));
        params.put("healthy", String.valueOf(instance.isHealthy()));
        params.put("ephemeral", String.valueOf(instance.isEphemeral()));
        params.put("metadata", JSON.toJSONString(instance.getMetadata()));
        this.reqAPI(UtilAndComs.NACOS_URL_INSTANCE, params, "POST");
    }

    public void deregisterService(String serviceName, Instance instance) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[DEREGISTER-SERVICE] {} deregistering service {} with instance: {}", this.namespaceId, serviceName, instance);
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", serviceName);
        params.put("clusterName", instance.getClusterName());
        params.put("ip", instance.getIp());
        params.put("port", String.valueOf(instance.getPort()));
        params.put("ephemeral", String.valueOf(instance.isEphemeral()));
        this.reqAPI(UtilAndComs.NACOS_URL_INSTANCE, params, "DELETE");
    }

    public void updateInstance(String serviceName, String groupName, Instance instance) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[UPDATE-SERVICE] {} update service {} with instance: {}", this.namespaceId, serviceName, instance);
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", serviceName);
        params.put("groupName", groupName);
        params.put("clusterName", instance.getClusterName());
        params.put("ip", instance.getIp());
        params.put("port", String.valueOf(instance.getPort()));
        params.put("weight", String.valueOf(instance.getWeight()));
        params.put("enabled", String.valueOf(instance.isEnabled()));
        params.put("ephemeral", String.valueOf(instance.isEphemeral()));
        params.put("metadata", JSON.toJSONString(instance.getMetadata()));
        this.reqAPI(UtilAndComs.NACOS_URL_INSTANCE, params, "PUT");
    }

    public Service queryService(String serviceName, String groupName) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[QUERY-SERVICE] {} query service : {}, {}", this.namespaceId, serviceName, groupName);
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", serviceName);
        params.put("groupName", groupName);
        String result = this.reqAPI(UtilAndComs.NACOS_URL_SERVICE, params, "GET");
        JSONObject jsonObject = JSON.parseObject((String)result);
        return (Service)jsonObject.toJavaObject(Service.class);
    }

    public void createService(Service service, AbstractSelector selector) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[CREATE-SERVICE] {} creating service : {}", (Object)this.namespaceId, (Object)service);
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", service.getName());
        params.put("groupName", service.getGroupName());
        params.put("protectThreshold", String.valueOf(service.getProtectThreshold()));
        params.put("metadata", JSON.toJSONString(service.getMetadata()));
        params.put("selector", JSON.toJSONString((Object)selector));
        this.reqAPI(UtilAndComs.NACOS_URL_SERVICE, params, "POST");
    }

    public boolean deleteService(String serviceName, String groupName) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[DELETE-SERVICE] {} deleting service : {} with groupName : {}", this.namespaceId, serviceName, groupName);
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", serviceName);
        params.put("groupName", groupName);
        String result = this.reqAPI(UtilAndComs.NACOS_URL_SERVICE, params, "DELETE");
        return "ok".equals(result);
    }

    public void updateService(Service service, AbstractSelector selector) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[UPDATE-SERVICE] {} updating service : {}", (Object)this.namespaceId, (Object)service);
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", service.getName());
        params.put("groupName", service.getGroupName());
        params.put("protectThreshold", String.valueOf(service.getProtectThreshold()));
        params.put("metadata", JSON.toJSONString(service.getMetadata()));
        params.put("selector", JSON.toJSONString((Object)selector));
        this.reqAPI(UtilAndComs.NACOS_URL_SERVICE, params, "PUT");
    }

    public String queryList(String serviceName, String clusters, int udpPort, boolean healthyOnly) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", serviceName);
        params.put("clusters", clusters);
        params.put("udpPort", String.valueOf(udpPort));
        params.put("clientIP", NetUtils.localIP());
        params.put("healthyOnly", String.valueOf(healthyOnly));
        return this.reqAPI(UtilAndComs.NACOS_URL_BASE + "/instance/list", params, "GET");
    }

    public long sendBeat(BeatInfo beatInfo) {
        try {
            if (LogUtils.NAMING_LOGGER.isDebugEnabled()) {
                LogUtils.NAMING_LOGGER.debug("[BEAT] {} sending beat to server: {}", (Object)this.namespaceId, (Object)beatInfo.toString());
            }
            HashMap<String, String> params = new HashMap<String, String>(4);
            params.put("beat", JSON.toJSONString((Object)beatInfo));
            params.put("namespaceId", this.namespaceId);
            params.put("serviceName", beatInfo.getServiceName());
            String result = this.reqAPI(UtilAndComs.NACOS_URL_BASE + "/instance/beat", params, "PUT");
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject != null) {
                return jsonObject.getLong("clientBeatInterval");
            }
        }
        catch (Exception e) {
            LogUtils.NAMING_LOGGER.error("[CLIENT-BEAT] failed to send beat: " + JSON.toJSONString((Object)beatInfo), e);
        }
        return 0L;
    }

    public boolean serverHealthy() {
        try {
            String result = this.reqAPI(UtilAndComs.NACOS_URL_BASE + "/operator/metrics", new HashMap<String, String>(2));
            JSONObject json = JSON.parseObject((String)result);
            String serverStatus = json.getString("status");
            return "UP".equals(serverStatus);
        }
        catch (Exception e) {
            return false;
        }
    }

    public ListView<String> getServiceList(int pageNo, int pageSize, String groupName) throws NacosException {
        return this.getServiceList(pageNo, pageSize, groupName, null);
    }

    public ListView<String> getServiceList(int pageNo, int pageSize, String groupName, AbstractSelector selector) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("pageNo", String.valueOf(pageNo));
        params.put("pageSize", String.valueOf(pageSize));
        params.put("namespaceId", this.namespaceId);
        params.put("groupName", groupName);
        if (selector != null) {
            switch (SelectorType.valueOf(selector.getType())) {
                case none: {
                    break;
                }
                case label: {
                    ExpressionSelector expressionSelector = (ExpressionSelector)selector;
                    params.put("selector", JSON.toJSONString((Object)expressionSelector));
                    break;
                }
            }
        }
        String result = this.reqAPI(UtilAndComs.NACOS_URL_BASE + "/service/list", params);
        JSONObject json = JSON.parseObject((String)result);
        ListView<String> listView = new ListView<String>();
        listView.setCount(json.getInteger("count"));
        listView.setData((List)JSON.parseObject((String)json.getString("doms"), (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]));
        return listView;
    }

    public String reqAPI(String api, Map<String, String> params) throws NacosException {
        List<String> snapshot = this.serversFromEndpoint;
        if (!CollectionUtils.isEmpty(this.serverList)) {
            snapshot = this.serverList;
        }
        return this.reqAPI(api, params, snapshot);
    }

    public String reqAPI(String api, Map<String, String> params, String method) throws NacosException {
        List<String> snapshot = this.serversFromEndpoint;
        if (!CollectionUtils.isEmpty(this.serverList)) {
            snapshot = this.serverList;
        }
        return this.reqAPI(api, params, snapshot, method);
    }

    public String callServer(String api, Map<String, String> params, String curServer) throws NacosException {
        return this.callServer(api, params, curServer, "GET");
    }

    public String callServer(String api, Map<String, String> params, String curServer, String method) throws NacosException {
        String url;
        long start = System.currentTimeMillis();
        long end = 0L;
        this.checkSignature(params);
        List<String> headers = this.builderHeaders();
        if (curServer.startsWith("https://") || curServer.startsWith("http://")) {
            url = curServer + api;
        } else {
            if (!curServer.contains(":")) {
                curServer = curServer + ":" + this.serverPort;
            }
            url = HttpClient.getPrefix() + curServer + api;
        }
        HttpClient.HttpResult result = HttpClient.request(url, headers, params, "UTF-8", method);
        end = System.currentTimeMillis();
        MetricsMonitor.getNamingRequestMonitor(method, url, String.valueOf(result.code)).observe(end - start);
        if (200 == result.code) {
            return result.content;
        }
        if (304 == result.code) {
            return "";
        }
        throw new NacosException(500, "failed to req API:" + curServer + api + ". code:" + result.code + " msg: " + result.content);
    }

    public String reqAPI(String api, Map<String, String> params, List<String> servers) {
        return this.reqAPI(api, params, servers, "GET");
    }

    public String reqAPI(String api, Map<String, String> params, List<String> servers, String method) {
        params.put("namespaceId", this.getNamespaceId());
        if (CollectionUtils.isEmpty(servers) && StringUtils.isEmpty(this.nacosDomain)) {
            throw new IllegalArgumentException("no server available");
        }
        Exception exception = new Exception();
        if (servers != null && !servers.isEmpty()) {
            Random random = new Random(System.currentTimeMillis());
            int index = random.nextInt(servers.size());
            for (int i2 = 0; i2 < servers.size(); ++i2) {
                String server = servers.get(index);
                try {
                    return this.callServer(api, params, server, method);
                }
                catch (NacosException e) {
                    exception = e;
                    LogUtils.NAMING_LOGGER.error("request {} failed.", (Object)server, (Object)e);
                }
                catch (Exception e) {
                    exception = e;
                    LogUtils.NAMING_LOGGER.error("request {} failed.", (Object)server, (Object)e);
                }
                index = (index + 1) % servers.size();
            }
            throw new IllegalStateException("failed to req API:" + api + " after all servers(" + servers + ") tried: " + exception.getMessage());
        }
        for (int i3 = 0; i3 < 3; ++i3) {
            try {
                return this.callServer(api, params, this.nacosDomain);
            }
            catch (Exception e) {
                exception = e;
                LogUtils.NAMING_LOGGER.error("[NA] req api:" + api + " failed, server(" + this.nacosDomain, e);
                continue;
            }
        }
        throw new IllegalStateException("failed to req API:/api/" + api + " after all servers(" + servers + ") tried: " + exception.getMessage());
    }

    private void checkSignature(Map<String, String> params) {
        String ak = this.getAccessKey();
        String sk = this.getSecretKey();
        if (StringUtils.isEmpty(ak) && StringUtils.isEmpty(sk)) {
            return;
        }
        try {
            String app = System.getProperty("project.name");
            String signData = NamingProxy.getSignData(params.get("serviceName"));
            String signature = SignUtil.sign(signData, sk);
            params.put("signature", signature);
            params.put("data", signData);
            params.put("ak", ak);
            params.put("app", app);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> builderHeaders() {
        List<String> headers = Arrays.asList("Client-Version", "Nacos-Java-Client:v1.1.1", "User-Agent", "Nacos-Java-Client:v1.1.1", "Accept-Encoding", "gzip,deflate,sdch", "Connection", "Keep-Alive", "RequestId", UuidUtils.generateUuid(), "Request-Module", "Naming");
        return headers;
    }

    private static String getSignData(String serviceName) {
        return StringUtils.isNotEmpty(serviceName) ? System.currentTimeMillis() + "@@" + serviceName : String.valueOf(System.currentTimeMillis());
    }

    public String getAccessKey() {
        if (this.properties == null) {
            return SpasAdapter.getAk();
        }
        return TemplateUtils.stringEmptyAndThenExecute(this.properties.getProperty("accessKey"), new Callable<String>(){

            @Override
            public String call() {
                return SpasAdapter.getAk();
            }
        });
    }

    public String getSecretKey() {
        if (this.properties == null) {
            return SpasAdapter.getSk();
        }
        return TemplateUtils.stringEmptyAndThenExecute(this.properties.getProperty("secretKey"), new Callable<String>(){

            @Override
            public String call() throws Exception {
                return SpasAdapter.getSk();
            }
        });
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        this.setServerPort(8848);
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
        String sp = System.getProperty("nacos.naming.exposed.port");
        if (StringUtils.isNotBlank(sp)) {
            this.serverPort = Integer.parseInt(sp);
        }
    }
}

