/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

public class PageUtil {
    private static int firstPageNo = 0;

    public static int getFirstPageNo() {
        return firstPageNo;
    }

    public static void setFirstPageNo(int customFirstPageNo) {
        firstPageNo = customFirstPageNo;
    }

    public static void setOneAsFirstPageNo() {
        PageUtil.setFirstPageNo(1);
    }

    public static int getStart(int pageNo, int pageSize) {
        if (pageNo < firstPageNo) {
            pageNo = firstPageNo;
        }
        if (pageSize < 1) {
            pageSize = 0;
        }
        return (pageNo - firstPageNo) * pageSize;
    }

    public static int getEnd(int pageNo, int pageSize) {
        int start = PageUtil.getStart(pageNo, pageSize);
        return PageUtil.getEndByStart(start, pageSize);
    }

    public static int[] transToStartEnd(int pageNo, int pageSize) {
        int start = PageUtil.getStart(pageNo, pageSize);
        return new int[]{start, PageUtil.getEndByStart(start, pageSize)};
    }

    public static int totalPage(int totalCount, int pageSize) {
        if (pageSize == 0) {
            return 0;
        }
        return totalCount % pageSize == 0 ? totalCount / pageSize : totalCount / pageSize + 1;
    }

    public static int[] rainbow(int pageNo, int totalPage, int displayCount) {
        boolean isEven = (displayCount & 1) == 0;
        int left = displayCount >> 1;
        int right = displayCount >> 1;
        int length = displayCount;
        if (isEven) {
            ++right;
        }
        if (totalPage < displayCount) {
            length = totalPage;
        }
        int[] result = new int[length];
        if (totalPage >= displayCount) {
            if (pageNo <= left) {
                for (int i2 = 0; i2 < result.length; ++i2) {
                    result[i2] = i2 + 1;
                }
            } else if (pageNo > totalPage - right) {
                for (int i3 = 0; i3 < result.length; ++i3) {
                    result[i3] = i3 + totalPage - displayCount + 1;
                }
            } else {
                for (int i4 = 0; i4 < result.length; ++i4) {
                    result[i4] = i4 + pageNo - left + (isEven ? 1 : 0);
                }
            }
        } else {
            for (int i5 = 0; i5 < result.length; ++i5) {
                result[i5] = i5 + 1;
            }
        }
        return result;
    }

    public static int[] rainbow(int currentPage, int pageCount) {
        return PageUtil.rainbow(currentPage, pageCount, 10);
    }

    private static int getEndByStart(int start, int pageSize) {
        if (pageSize < 1) {
            pageSize = 0;
        }
        return start + pageSize;
    }
}

