/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.messaging;

import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.handler.MessagingAdviceBean;
import org.springframework.messaging.handler.annotation.support.AnnotationExceptionHandlerMethodResolver;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.simp.annotation.support.SimpAnnotationMethodMessageHandler;
import org.springframework.web.method.ControllerAdviceBean;

public class WebSocketAnnotationMethodMessageHandler
extends SimpAnnotationMethodMessageHandler {
    public WebSocketAnnotationMethodMessageHandler(SubscribableChannel clientInChannel, MessageChannel clientOutChannel, SimpMessageSendingOperations brokerTemplate) {
        super(clientInChannel, clientOutChannel, brokerTemplate);
    }

    @Override
    public void afterPropertiesSet() {
        this.initControllerAdviceCache();
        super.afterPropertiesSet();
    }

    private void initControllerAdviceCache() {
        ApplicationContext context = this.getApplicationContext();
        if (context == null) {
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Looking for @MessageExceptionHandler mappings: " + context);
        }
        List<ControllerAdviceBean> beans2 = ControllerAdviceBean.findAnnotatedBeans(context);
        this.initMessagingAdviceCache(MessagingControllerAdviceBean.createFromList(beans2));
    }

    private void initMessagingAdviceCache(List<MessagingAdviceBean> beans2) {
        for (MessagingAdviceBean bean2 : beans2) {
            AnnotationExceptionHandlerMethodResolver resolver;
            Class<?> type = bean2.getBeanType();
            if (type == null || !(resolver = new AnnotationExceptionHandlerMethodResolver(type)).hasExceptionMappings()) continue;
            this.registerExceptionHandlerAdvice(bean2, resolver);
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace("Detected @MessageExceptionHandler methods in " + bean2);
        }
    }

    private static final class MessagingControllerAdviceBean
    implements MessagingAdviceBean {
        private final ControllerAdviceBean adviceBean;

        private MessagingControllerAdviceBean(ControllerAdviceBean adviceBean) {
            this.adviceBean = adviceBean;
        }

        public static List<MessagingAdviceBean> createFromList(List<ControllerAdviceBean> beans2) {
            ArrayList<MessagingAdviceBean> result = new ArrayList<MessagingAdviceBean>(beans2.size());
            for (ControllerAdviceBean bean2 : beans2) {
                result.add(new MessagingControllerAdviceBean(bean2));
            }
            return result;
        }

        @Override
        @Nullable
        public Class<?> getBeanType() {
            return this.adviceBean.getBeanType();
        }

        @Override
        public Object resolveBean() {
            return this.adviceBean.resolveBean();
        }

        @Override
        public boolean isApplicableToBeanType(Class<?> beanType) {
            return this.adviceBean.isApplicableToBeanType(beanType);
        }

        @Override
        public int getOrder() {
            return this.adviceBean.getOrder();
        }
    }
}

