/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UrlPathHelper;

class DefaultServerRequest
implements ServerRequest {
    private final ServletServerHttpRequest serverHttpRequest;
    private final ServerRequest.Headers headers;
    private final List<HttpMessageConverter<?>> messageConverters;
    private final List<MediaType> allSupportedMediaTypes;
    private final MultiValueMap<String, String> params;
    private final Map<String, Object> attributes;

    public DefaultServerRequest(HttpServletRequest servletRequest, List<HttpMessageConverter<?>> messageConverters) {
        this.serverHttpRequest = new ServletServerHttpRequest(servletRequest);
        this.messageConverters = Collections.unmodifiableList(new ArrayList(messageConverters));
        this.allSupportedMediaTypes = DefaultServerRequest.allSupportedMediaTypes(messageConverters);
        this.headers = new DefaultRequestHeaders(this.serverHttpRequest.getHeaders());
        this.params = CollectionUtils.toMultiValueMap(new ServletParametersMap(servletRequest));
        this.attributes = new ServletAttributesMap(servletRequest);
    }

    private static List<MediaType> allSupportedMediaTypes(List<HttpMessageConverter<?>> messageConverters) {
        return messageConverters.stream().flatMap(converter -> converter.getSupportedMediaTypes().stream()).sorted(MediaType.SPECIFICITY_COMPARATOR).collect(Collectors.toList());
    }

    @Override
    public String methodName() {
        return this.servletRequest().getMethod();
    }

    @Override
    public URI uri() {
        return this.serverHttpRequest.getURI();
    }

    @Override
    public UriBuilder uriBuilder() {
        return ServletUriComponentsBuilder.fromRequest(this.servletRequest());
    }

    @Override
    public String path() {
        String path = (String)this.servletRequest().getAttribute(HandlerMapping.LOOKUP_PATH);
        if (path == null) {
            UrlPathHelper helper = new UrlPathHelper();
            path = helper.getLookupPathForRequest(this.servletRequest());
        }
        return path;
    }

    @Override
    public ServerRequest.Headers headers() {
        return this.headers;
    }

    @Override
    public MultiValueMap<String, Cookie> cookies() {
        Cookie[] cookies = this.servletRequest().getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        LinkedMultiValueMap<String, Cookie> result = new LinkedMultiValueMap<String, Cookie>(cookies.length);
        for (Cookie cookie : cookies) {
            result.add(cookie.getName(), cookie);
        }
        return result;
    }

    @Override
    public HttpServletRequest servletRequest() {
        return this.serverHttpRequest.getServletRequest();
    }

    @Override
    public Optional<InetSocketAddress> remoteAddress() {
        return Optional.of(this.serverHttpRequest.getRemoteAddress());
    }

    @Override
    public List<HttpMessageConverter<?>> messageConverters() {
        return this.messageConverters;
    }

    @Override
    public <T> T body(Class<T> bodyType) throws IOException, ServletException {
        return this.bodyInternal(bodyType, bodyType);
    }

    @Override
    public <T> T body(ParameterizedTypeReference<T> bodyType) throws IOException, ServletException {
        Type type = bodyType.getType();
        return this.bodyInternal(type, DefaultServerRequest.bodyClass(type));
    }

    static Class<?> bodyClass(Type type) {
        ParameterizedType parameterizedType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() instanceof Class) {
            return (Class)parameterizedType.getRawType();
        }
        return Object.class;
    }

    private <T> T bodyInternal(Type bodyType, Class<?> bodyClass) throws ServletException, IOException {
        MediaType contentType = this.headers.contentType().orElse(MediaType.APPLICATION_OCTET_STREAM);
        for (HttpMessageConverter<?> messageConverter : this.messageConverters) {
            GenericHttpMessageConverter genericMessageConverter;
            if (messageConverter instanceof GenericHttpMessageConverter && (genericMessageConverter = (GenericHttpMessageConverter)messageConverter).canRead(bodyType, bodyClass, contentType)) {
                return genericMessageConverter.read(bodyType, bodyClass, this.serverHttpRequest);
            }
            if (!messageConverter.canRead(bodyClass, contentType)) continue;
            HttpMessageConverter<?> theConverter = messageConverter;
            Class<?> clazz = bodyClass;
            return (T)theConverter.read(clazz, this.serverHttpRequest);
        }
        throw new HttpMediaTypeNotSupportedException(contentType, this.allSupportedMediaTypes);
    }

    @Override
    public Optional<Object> attribute(String name) {
        return Optional.ofNullable(this.servletRequest().getAttribute(name));
    }

    @Override
    public Map<String, Object> attributes() {
        return this.attributes;
    }

    @Override
    public Optional<String> param(String name) {
        return Optional.ofNullable(this.servletRequest().getParameter(name));
    }

    @Override
    public MultiValueMap<String, String> params() {
        return this.params;
    }

    @Override
    public Map<String, String> pathVariables() {
        Map pathVariables = (Map)this.servletRequest().getAttribute(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        if (pathVariables != null) {
            return pathVariables;
        }
        return Collections.emptyMap();
    }

    @Override
    public HttpSession session() {
        return this.servletRequest().getSession(true);
    }

    @Override
    public Optional<Principal> principal() {
        return Optional.ofNullable(this.serverHttpRequest.getPrincipal());
    }

    private static final class ServletAttributesMap
    extends AbstractMap<String, Object> {
        private final HttpServletRequest servletRequest;

        private ServletAttributesMap(HttpServletRequest servletRequest) {
            this.servletRequest = servletRequest;
        }

        @Override
        public boolean containsKey(Object key) {
            String name = (String)key;
            return this.servletRequest.getAttribute(name) != null;
        }

        @Override
        public void clear() {
            ArrayList<String> attributeNames = Collections.list(this.servletRequest.getAttributeNames());
            attributeNames.forEach(this.servletRequest::removeAttribute);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return Collections.list(this.servletRequest.getAttributeNames()).stream().map(name -> {
                Object value = this.servletRequest.getAttribute((String)name);
                return new AbstractMap.SimpleImmutableEntry<String, Object>((String)name, value);
            }).collect(Collectors.toSet());
        }

        @Override
        public Object get(Object key) {
            String name = (String)key;
            return this.servletRequest.getAttribute(name);
        }

        @Override
        public Object put(String key, Object value) {
            Object oldValue = this.servletRequest.getAttribute(key);
            this.servletRequest.setAttribute(key, value);
            return oldValue;
        }

        @Override
        public Object remove(Object key) {
            String name = (String)key;
            Object value = this.servletRequest.getAttribute(name);
            this.servletRequest.removeAttribute(name);
            return value;
        }
    }

    private static final class ServletParametersMap
    extends AbstractMap<String, List<String>> {
        private final HttpServletRequest servletRequest;

        private ServletParametersMap(HttpServletRequest servletRequest) {
            this.servletRequest = servletRequest;
        }

        @Override
        public Set<Map.Entry<String, List<String>>> entrySet() {
            return this.servletRequest.getParameterMap().entrySet().stream().map(entry -> {
                List<Object> value = Arrays.asList((Object[])entry.getValue());
                return new AbstractMap.SimpleImmutableEntry(entry.getKey(), value);
            }).collect(Collectors.toSet());
        }

        @Override
        public int size() {
            return this.servletRequest.getParameterMap().size();
        }

        @Override
        public List<String> get(Object key) {
            String name = (String)key;
            Object[] parameterValues = this.servletRequest.getParameterValues(name);
            if (!ObjectUtils.isEmpty(parameterValues)) {
                return Arrays.asList(parameterValues);
            }
            return Collections.emptyList();
        }

        @Override
        public List<String> put(String key, List<String> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    static class DefaultRequestHeaders
    implements ServerRequest.Headers {
        private final HttpHeaders delegate;

        public DefaultRequestHeaders(HttpHeaders delegate) {
            this.delegate = delegate;
        }

        @Override
        public List<MediaType> accept() {
            return this.delegate.getAccept();
        }

        @Override
        public List<Charset> acceptCharset() {
            return this.delegate.getAcceptCharset();
        }

        @Override
        public List<Locale.LanguageRange> acceptLanguage() {
            return this.delegate.getAcceptLanguage();
        }

        @Override
        public OptionalLong contentLength() {
            long value = this.delegate.getContentLength();
            return value != -1L ? OptionalLong.of(value) : OptionalLong.empty();
        }

        @Override
        public Optional<MediaType> contentType() {
            return Optional.ofNullable(this.delegate.getContentType());
        }

        @Override
        public InetSocketAddress host() {
            return this.delegate.getHost();
        }

        @Override
        public List<HttpRange> range() {
            return this.delegate.getRange();
        }

        @Override
        public List<String> header(String headerName) {
            List<String> headerValues = this.delegate.get(headerName);
            return headerValues != null ? headerValues : Collections.emptyList();
        }

        @Override
        public HttpHeaders asHttpHeaders() {
            return HttpHeaders.readOnlyHttpHeaders(this.delegate);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

