/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.configuration;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.data.keyvalue.repository.config.KeyValueRepositoryConfigurationExtension;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.data.redis.core.RedisKeyValueAdapter;
import org.springframework.data.redis.core.RedisKeyValueTemplate;
import org.springframework.data.redis.core.convert.MappingConfiguration;
import org.springframework.data.redis.core.convert.MappingRedisConverter;
import org.springframework.data.redis.core.convert.RedisCustomConversions;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.util.StringUtils;

public class RedisRepositoryConfigurationExtension
extends KeyValueRepositoryConfigurationExtension {
    private static final String REDIS_CONVERTER_BEAN_NAME = "redisConverter";
    private static final String REDIS_REFERENCE_RESOLVER_BEAN_NAME = "redisReferenceResolver";
    private static final String REDIS_ADAPTER_BEAN_NAME = "redisKeyValueAdapter";
    private static final String REDIS_CUSTOM_CONVERSIONS_BEAN_NAME = "redisCustomConversions";

    @Override
    public String getModuleName() {
        return "Redis";
    }

    @Override
    protected String getModulePrefix() {
        return "redis";
    }

    @Override
    protected String getDefaultKeyValueTemplateRef() {
        return "redisKeyValueTemplate";
    }

    @Override
    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configuration) {
        String redisTemplateRef = configuration.getAttribute("redisTemplateRef").get();
        if (!StringUtils.hasText(redisTemplateRef)) {
            throw new IllegalStateException("@EnableRedisRepositories(redisTemplateRef = \u2026 ) must be configured to a non empty value!");
        }
        RedisRepositoryConfigurationExtension.registerIfNotAlreadyRegistered(() -> RedisRepositoryConfigurationExtension.createRedisMappingContext(configuration), registry, "keyValueMappingContext", configuration.getSource());
        RedisRepositoryConfigurationExtension.registerIfNotAlreadyRegistered(() -> new RootBeanDefinition(RedisCustomConversions.class), registry, REDIS_CUSTOM_CONVERSIONS_BEAN_NAME, configuration.getSource());
        RedisRepositoryConfigurationExtension.registerIfNotAlreadyRegistered(() -> RedisRepositoryConfigurationExtension.createRedisReferenceResolverDefinition(redisTemplateRef), registry, REDIS_REFERENCE_RESOLVER_BEAN_NAME, configuration.getSource());
        RedisRepositoryConfigurationExtension.registerIfNotAlreadyRegistered(() -> RedisRepositoryConfigurationExtension.createRedisConverterDefinition(), registry, REDIS_CONVERTER_BEAN_NAME, configuration.getSource());
        RedisRepositoryConfigurationExtension.registerIfNotAlreadyRegistered(() -> RedisRepositoryConfigurationExtension.createRedisKeyValueAdapter(configuration), registry, REDIS_ADAPTER_BEAN_NAME, configuration.getSource());
        super.registerBeansForRoot(registry, configuration);
    }

    @Override
    protected AbstractBeanDefinition getDefaultKeyValueTemplateBeanDefinition(RepositoryConfigurationSource configurationSource) {
        return BeanDefinitionBuilder.rootBeanDefinition(RedisKeyValueTemplate.class).addConstructorArgReference(REDIS_ADAPTER_BEAN_NAME).addConstructorArgReference("keyValueMappingContext").getBeanDefinition();
    }

    @Override
    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(RedisHash.class);
    }

    private static AbstractBeanDefinition createRedisKeyValueAdapter(RepositoryConfigurationSource configuration) {
        return BeanDefinitionBuilder.rootBeanDefinition(RedisKeyValueAdapter.class).addConstructorArgReference(configuration.getRequiredAttribute("redisTemplateRef", String.class)).addConstructorArgReference(REDIS_CONVERTER_BEAN_NAME).addPropertyValue("enableKeyspaceEvents", (Object)configuration.getRequiredAttribute("enableKeyspaceEvents", RedisKeyValueAdapter.EnableKeyspaceEvents.class)).addPropertyValue("keyspaceNotificationsConfigParameter", configuration.getAttribute("keyspaceNotificationsConfigParameter", String.class).orElse("")).getBeanDefinition();
    }

    private static AbstractBeanDefinition createRedisReferenceResolverDefinition(String redisTemplateRef) {
        return BeanDefinitionBuilder.rootBeanDefinition("org.springframework.data.redis.core.convert.ReferenceResolverImpl").addConstructorArgReference(redisTemplateRef).getBeanDefinition();
    }

    private static AbstractBeanDefinition createRedisMappingContext(RepositoryConfigurationSource configurationSource) {
        return BeanDefinitionBuilder.rootBeanDefinition(RedisMappingContext.class).addConstructorArgValue(RedisRepositoryConfigurationExtension.createMappingConfigBeanDef(configurationSource)).getBeanDefinition();
    }

    private static BeanDefinition createMappingConfigBeanDef(RepositoryConfigurationSource configuration) {
        AbstractBeanDefinition indexDefinition = BeanDefinitionBuilder.genericBeanDefinition(configuration.getRequiredAttribute("indexConfiguration", Class.class)).getBeanDefinition();
        AbstractBeanDefinition keyspaceDefinition = BeanDefinitionBuilder.genericBeanDefinition(configuration.getRequiredAttribute("keyspaceConfiguration", Class.class)).getBeanDefinition();
        return BeanDefinitionBuilder.genericBeanDefinition(MappingConfiguration.class).addConstructorArgValue(indexDefinition).addConstructorArgValue(keyspaceDefinition).getBeanDefinition();
    }

    private static AbstractBeanDefinition createRedisConverterDefinition() {
        return BeanDefinitionBuilder.rootBeanDefinition(MappingRedisConverter.class).addConstructorArgReference("keyValueMappingContext").addPropertyReference("referenceResolver", REDIS_REFERENCE_RESOLVER_BEAN_NAME).addPropertyReference("customConversions", REDIS_CUSTOM_CONVERSIONS_BEAN_NAME).getBeanDefinition();
    }
}

