/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.BoundKeyOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface BoundValueOperations<K, V>
extends BoundKeyOperations<K> {
    public void set(V var1);

    public void set(V var1, long var2, TimeUnit var4);

    default public void set(V value, Duration timeout) {
        Assert.notNull((Object)timeout, "Timeout must not be null!");
        if (TimeoutUtils.hasMillis(timeout)) {
            this.set(value, timeout.toMillis(), TimeUnit.MILLISECONDS);
        } else {
            this.set(value, timeout.getSeconds(), TimeUnit.SECONDS);
        }
    }

    @Nullable
    public Boolean setIfAbsent(V var1);

    @Nullable
    public Boolean setIfAbsent(V var1, long var2, TimeUnit var4);

    @Nullable
    default public Boolean setIfAbsent(V value, Duration timeout) {
        Assert.notNull((Object)timeout, "Timeout must not be null!");
        if (TimeoutUtils.hasMillis(timeout)) {
            return this.setIfAbsent(value, timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        return this.setIfAbsent(value, timeout.getSeconds(), TimeUnit.SECONDS);
    }

    @Nullable
    public Boolean setIfPresent(V var1);

    @Nullable
    public Boolean setIfPresent(V var1, long var2, TimeUnit var4);

    @Nullable
    default public Boolean setIfPresent(V value, Duration timeout) {
        Assert.notNull((Object)timeout, "Timeout must not be null!");
        if (TimeoutUtils.hasMillis(timeout)) {
            return this.setIfPresent(value, timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        return this.setIfPresent(value, timeout.getSeconds(), TimeUnit.SECONDS);
    }

    @Nullable
    public V get();

    @Nullable
    public V getAndSet(V var1);

    @Nullable
    public Long increment();

    @Nullable
    public Long increment(long var1);

    @Nullable
    public Double increment(double var1);

    @Nullable
    public Long decrement();

    @Nullable
    public Long decrement(long var1);

    @Nullable
    public Integer append(String var1);

    @Nullable
    public String get(long var1, long var3);

    public void set(V var1, long var2);

    @Nullable
    public Long size();

    public RedisOperations<K, V> getOperations();
}

