/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.util.Assert;

public final class ReadOffset {
    private final String offset;

    private ReadOffset(String offset) {
        this.offset = offset;
    }

    public static ReadOffset latest() {
        return new ReadOffset("$");
    }

    public static ReadOffset lastConsumed() {
        return new ReadOffset(">");
    }

    public static ReadOffset from(String offset) {
        Assert.hasText(offset, "Offset must not be empty");
        return new ReadOffset(offset);
    }

    public static ReadOffset from(RecordId offset) {
        if (offset.shouldBeAutoGenerated()) {
            return ReadOffset.latest();
        }
        return ReadOffset.from(offset.getValue());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadOffset)) {
            return false;
        }
        ReadOffset other = (ReadOffset)o;
        String this$offset = this.getOffset();
        String other$offset = other.getOffset();
        return !(this$offset == null ? other$offset != null : !this$offset.equals(other$offset));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : $offset.hashCode());
        return result;
    }

    public String toString() {
        return "ReadOffset(offset=" + this.getOffset() + ")";
    }

    public String getOffset() {
        return this.offset;
    }
}

