/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.Range;
import io.lettuce.core.codec.StringCodec;
import java.util.function.Function;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class RangeConverter {
    RangeConverter() {
    }

    static <T> Range<T> toRange(org.springframework.data.domain.Range<?> range) {
        return RangeConverter.toRange(range, StringCodec.UTF8::encodeValue);
    }

    static <T> Range<T> toRange(org.springframework.data.domain.Range<?> range, Function<String, ? extends Object> stringEncoder) {
        return Range.from(RangeConverter.lowerBoundArgOf(range, stringEncoder), RangeConverter.upperBoundArgOf(range, stringEncoder));
    }

    private static <T> Range.Boundary<T> lowerBoundArgOf(org.springframework.data.domain.Range<?> range, Function<String, ? extends Object> stringEncoder) {
        return RangeConverter.rangeToBoundArgumentConverter(false, stringEncoder).convert(range);
    }

    private static <T> Range.Boundary<T> upperBoundArgOf(org.springframework.data.domain.Range<?> range, Function<String, ? extends Object> stringEncoder) {
        return RangeConverter.rangeToBoundArgumentConverter(true, stringEncoder).convert(range);
    }

    private static Converter<org.springframework.data.domain.Range<?>, Range.Boundary<?>> rangeToBoundArgumentConverter(boolean upper, Function<String, ? extends Object> stringEncoder) {
        return source -> {
            Object value;
            Boolean inclusive = upper ? source.getUpperBound().isInclusive() : source.getLowerBound().isInclusive();
            Object v0 = value = upper ? source.getUpperBound().getValue().orElse(null) : source.getLowerBound().getValue().orElse(null);
            if (value instanceof Number) {
                return inclusive != false ? Range.Boundary.including(value) : Range.Boundary.excluding(value);
            }
            if (value instanceof String) {
                if (!StringUtils.hasText(value) || ObjectUtils.nullSafeEquals(value, "+") || ObjectUtils.nullSafeEquals(value, "-")) {
                    return Range.Boundary.unbounded();
                }
                Object encoded = stringEncoder.apply(value);
                return inclusive != false ? Range.Boundary.including(encoded) : Range.Boundary.excluding(encoded);
            }
            if (value == null) {
                return Range.Boundary.unbounded();
            }
            return inclusive != false ? Range.Boundary.including(value) : Range.Boundary.excluding(value);
        };
    }
}

