/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.context.event;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.spring.boot.util.DubboUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;

@Order(value=-2147483627)
public class WelcomeLogoApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static AtomicBoolean processed = new AtomicBoolean(false);

    @Override
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        if (processed.get()) {
            return;
        }
        Logger logger2 = LoggerFactory.getLogger(this.getClass());
        String bannerText = this.buildBannerText();
        if (logger2.isInfoEnabled()) {
            logger2.info(bannerText);
        } else {
            System.out.print(bannerText);
        }
        processed.compareAndSet(false, true);
    }

    String buildBannerText() {
        StringBuilder bannerTextBuilder = new StringBuilder();
        bannerTextBuilder.append(DubboUtils.LINE_SEPARATOR).append(DubboUtils.LINE_SEPARATOR).append(" :: Dubbo Spring Boot (v").append(Version.getVersion(this.getClass(), Version.getVersion())).append(") : ").append("https://github.com/apache/dubbo-spring-boot-project").append(DubboUtils.LINE_SEPARATOR).append(" :: Dubbo (v").append(Version.getVersion()).append(") : ").append("https://github.com/apache/incubator-dubbo").append(DubboUtils.LINE_SEPARATOR).append(" :: Discuss group : ").append("dev@dubbo.apache.org").append(DubboUtils.LINE_SEPARATOR);
        return bannerTextBuilder.toString();
    }
}

