/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.spring.extension.SpringExtensionFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class ConfigCenterBean
extends ConfigCenterConfig
implements ApplicationContextAware,
DisposableBean,
EnvironmentAware {
    private transient ApplicationContext applicationContext;
    private Boolean includeSpringEnv = false;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        SpringExtensionFactory.addApplicationContext(applicationContext);
    }

    @Override
    public void destroy() throws Exception {
    }

    @Override
    public void setEnvironment(Environment environment2) {
        if (this.includeSpringEnv.booleanValue()) {
            Map<String, String> externalProperties = this.getConfigurations(this.getConfigFile(), environment2);
            Map<String, String> appExternalProperties = this.getConfigurations(StringUtils.isNotEmpty(this.getAppConfigFile()) ? this.getAppConfigFile() : "application." + this.getConfigFile(), environment2);
            org.apache.dubbo.common.config.Environment.getInstance().setExternalConfigMap(externalProperties);
            org.apache.dubbo.common.config.Environment.getInstance().setAppExternalConfigMap(appExternalProperties);
        }
    }

    private Map<String, String> getConfigurations(String key, Environment environment2) {
        Object rawProperties = environment2.getProperty(key, Object.class);
        HashMap<String, String> externalProperties = new HashMap<String, String>();
        try {
            Object source;
            ConfigurableEnvironment configurableEnvironment;
            PropertySource<?> propertySource;
            if (rawProperties instanceof Map) {
                externalProperties.putAll((Map)rawProperties);
            } else if (rawProperties instanceof String) {
                externalProperties.putAll(ConfigurationUtils.parseProperties((String)rawProperties));
            }
            if (environment2 instanceof ConfigurableEnvironment && externalProperties.isEmpty() && (propertySource = (configurableEnvironment = (ConfigurableEnvironment)environment2).getPropertySources().get(key)) != null && (source = propertySource.getSource()) instanceof Map) {
                ((Map)source).forEach((k, v) -> externalProperties.put((String)k, (String)v));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return externalProperties;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Boolean getIncludeSpringEnv() {
        return this.includeSpringEnv;
    }

    public void setIncludeSpringEnv(Boolean includeSpringEnv) {
        this.includeSpringEnv = includeSpringEnv;
    }
}

