/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.util.Iterator;
import java.util.List;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.DubboAppender;
import org.apache.dubbo.common.utils.Log;
import org.apache.log4j.Level;

public class LogUtil {
    private static Logger Log = LoggerFactory.getLogger(LogUtil.class);

    public static void start() {
        DubboAppender.doStart();
    }

    public static void stop() {
        DubboAppender.doStop();
    }

    public static boolean checkNoError() {
        return LogUtil.findLevel(Level.ERROR) == 0;
    }

    public static int findName(String expectedLogName) {
        int count = 0;
        List<Log> logList = DubboAppender.logList;
        for (int i2 = 0; i2 < logList.size(); ++i2) {
            String logName = logList.get(i2).getLogName();
            if (!logName.contains(expectedLogName)) continue;
            ++count;
        }
        return count;
    }

    public static int findLevel(Level expectedLevel) {
        int count = 0;
        List<Log> logList = DubboAppender.logList;
        for (int i2 = 0; i2 < logList.size(); ++i2) {
            Level logLevel = logList.get(i2).getLogLevel();
            if (!logLevel.equals((Object)expectedLevel)) continue;
            ++count;
        }
        return count;
    }

    public static int findLevelWithThreadName(Level expectedLevel, String threadName) {
        int count = 0;
        List<Log> logList = DubboAppender.logList;
        for (int i2 = 0; i2 < logList.size(); ++i2) {
            Log log = logList.get(i2);
            if (!log.getLogLevel().equals((Object)expectedLevel) || !log.getLogThread().equals(threadName)) continue;
            ++count;
        }
        return count;
    }

    public static int findThread(String expectedThread) {
        int count = 0;
        List<Log> logList = DubboAppender.logList;
        for (int i2 = 0; i2 < logList.size(); ++i2) {
            String logThread = logList.get(i2).getLogThread();
            if (!logThread.contains(expectedThread)) continue;
            ++count;
        }
        return count;
    }

    public static int findMessage(String expectedMessage) {
        int count = 0;
        List<Log> logList = DubboAppender.logList;
        for (int i2 = 0; i2 < logList.size(); ++i2) {
            String logMessage = logList.get(i2).getLogMessage();
            if (!logMessage.contains(expectedMessage)) continue;
            ++count;
        }
        return count;
    }

    public static int findMessage(Level expectedLevel, String expectedMessage) {
        int count = 0;
        List<Log> logList = DubboAppender.logList;
        for (int i2 = 0; i2 < logList.size(); ++i2) {
            String logMessage;
            Level logLevel = logList.get(i2).getLogLevel();
            if (!logLevel.equals((Object)expectedLevel) || !(logMessage = logList.get(i2).getLogMessage()).contains(expectedMessage)) continue;
            ++count;
        }
        return count;
    }

    public static <T> void printList(List<T> list) {
        Log.info("PrintList:");
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            Log.info(it.next().toString());
        }
    }
}

