/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.logger;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Level;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerAdapter;
import org.apache.dubbo.common.logger.jcl.JclLoggerAdapter;
import org.apache.dubbo.common.logger.jdk.JdkLoggerAdapter;
import org.apache.dubbo.common.logger.log4j.Log4jLoggerAdapter;
import org.apache.dubbo.common.logger.log4j2.Log4j2LoggerAdapter;
import org.apache.dubbo.common.logger.slf4j.Slf4jLoggerAdapter;
import org.apache.dubbo.common.logger.support.FailsafeLogger;

public class LoggerFactory {
    private static final ConcurrentMap<String, FailsafeLogger> LOGGERS;
    private static volatile LoggerAdapter LOGGER_ADAPTER;

    private LoggerFactory() {
    }

    public static void setLoggerAdapter(String loggerAdapter) {
        if (loggerAdapter != null && loggerAdapter.length() > 0) {
            LoggerFactory.setLoggerAdapter(ExtensionLoader.getExtensionLoader(LoggerAdapter.class).getExtension(loggerAdapter));
        }
    }

    public static void setLoggerAdapter(LoggerAdapter loggerAdapter) {
        if (loggerAdapter != null) {
            Logger logger2 = loggerAdapter.getLogger(LoggerFactory.class.getName());
            logger2.info("using logger: " + loggerAdapter.getClass().getName());
            LOGGER_ADAPTER = loggerAdapter;
            for (Map.Entry entry : LOGGERS.entrySet()) {
                ((FailsafeLogger)entry.getValue()).setLogger(LOGGER_ADAPTER.getLogger((String)entry.getKey()));
            }
        }
    }

    public static Logger getLogger(Class<?> key) {
        return LOGGERS.computeIfAbsent(key.getName(), name -> new FailsafeLogger(LOGGER_ADAPTER.getLogger((String)name)));
    }

    public static Logger getLogger(String key) {
        return LOGGERS.computeIfAbsent(key, k -> new FailsafeLogger(LOGGER_ADAPTER.getLogger((String)k)));
    }

    public static Level getLevel() {
        return LOGGER_ADAPTER.getLevel();
    }

    public static void setLevel(Level level) {
        LOGGER_ADAPTER.setLevel(level);
    }

    public static File getFile() {
        return LOGGER_ADAPTER.getFile();
    }

    static {
        String logger2;
        LOGGERS = new ConcurrentHashMap<String, FailsafeLogger>();
        block8 : switch (logger2 = System.getProperty("dubbo.application.logger", "")) {
            case "slf4j": {
                LoggerFactory.setLoggerAdapter(new Slf4jLoggerAdapter());
                break;
            }
            case "jcl": {
                LoggerFactory.setLoggerAdapter(new JclLoggerAdapter());
                break;
            }
            case "log4j": {
                LoggerFactory.setLoggerAdapter(new Log4jLoggerAdapter());
                break;
            }
            case "jdk": {
                LoggerFactory.setLoggerAdapter(new JdkLoggerAdapter());
                break;
            }
            case "log4j2": {
                LoggerFactory.setLoggerAdapter(new Log4j2LoggerAdapter());
                break;
            }
            default: {
                List<Class> candidates = Arrays.asList(Log4jLoggerAdapter.class, Slf4jLoggerAdapter.class, Log4j2LoggerAdapter.class, JclLoggerAdapter.class, JdkLoggerAdapter.class);
                for (Class clazz : candidates) {
                    try {
                        LoggerFactory.setLoggerAdapter((LoggerAdapter)clazz.newInstance());
                        break block8;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
        }
    }
}

