/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.internal.LettuceAssert;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

class Futures {
    Futures() {
    }

    static Promise<Boolean> toBooleanPromise(Future<?> future) {
        DefaultPromise<Boolean> result = new DefaultPromise<Boolean>(GlobalEventExecutor.INSTANCE);
        if (future.isDone() || future.isCancelled()) {
            if (future.isSuccess()) {
                result.setSuccess(true);
            } else {
                result.setFailure(future.cause());
            }
            return result;
        }
        future.addListener(f -> {
            if (f.isSuccess()) {
                result.setSuccess(true);
            } else {
                result.setFailure(f.cause());
            }
        });
        return result;
    }

    static class PromiseAggregator<V, F extends Future<V>>
    implements GenericFutureListener<F> {
        private final Promise<?> aggregatePromise;
        private Set<Promise<V>> pendingPromises;
        private AtomicInteger expectedPromises = new AtomicInteger();
        private AtomicInteger processedPromises = new AtomicInteger();
        private boolean armed;

        public PromiseAggregator(Promise<V> aggregatePromise) {
            LettuceAssert.notNull(aggregatePromise, "AggregatePromise must not be null");
            this.aggregatePromise = aggregatePromise;
        }

        public void expectMore(int count) {
            LettuceAssert.assertState(!this.armed, "Aggregator is armed and does not allow any further expectations");
            this.expectedPromises.addAndGet(count);
        }

        public void arm() {
            LettuceAssert.assertState(!this.armed, "Aggregator is already armed");
            this.armed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SafeVarargs
        public final PromiseAggregator<V, F> add(Promise<V> ... promises) {
            LettuceAssert.notNull(promises, "Promises must not be null");
            LettuceAssert.assertState(this.armed, "Aggregator is not armed and does not allow adding promises in that state. Call arm() first.");
            if (promises.length == 0) {
                return this;
            }
            PromiseAggregator promiseAggregator = this;
            synchronized (promiseAggregator) {
                if (this.pendingPromises == null) {
                    int size = promises.length > 1 ? promises.length : 2;
                    this.pendingPromises = new LinkedHashSet<Promise<V>>(size);
                }
                for (Promise<V> p : promises) {
                    if (p == null) continue;
                    this.pendingPromises.add(p);
                    p.addListener(this);
                }
            }
            return this;
        }

        @Override
        public synchronized void operationComplete(F future) throws Exception {
            if (this.pendingPromises == null) {
                this.aggregatePromise.setSuccess(null);
            } else {
                this.pendingPromises.remove(future);
                this.processedPromises.incrementAndGet();
                if (!future.isSuccess()) {
                    Throwable cause = future.cause();
                    this.aggregatePromise.setFailure(cause);
                    for (Promise<V> pendingFuture : this.pendingPromises) {
                        pendingFuture.setFailure(cause);
                    }
                } else if (this.processedPromises.get() == this.expectedPromises.get()) {
                    if (this.pendingPromises.isEmpty()) {
                        this.aggregatePromise.setSuccess(null);
                    } else {
                        throw new IllegalStateException("Processed promises == expected promises but pending promises is not empty. This should not have happened!");
                    }
                }
            }
        }
    }
}

