/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterslave;

import io.lettuce.core.RedisURI;
import io.lettuce.core.masterslave.CompletableEventLatchSupport;
import io.lettuce.core.masterslave.MasterSlaveUtils;
import io.lettuce.core.masterslave.TimedAsyncCommand;
import io.lettuce.core.masterslave.TopologyComparators;
import io.lettuce.core.models.role.RedisNodeDescription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

class Requests
extends CompletableEventLatchSupport<Tuple2<RedisURI, TimedAsyncCommand<String, String, String>>, List<RedisNodeDescription>> {
    private final Map<RedisURI, TimedAsyncCommand<String, String, String>> rawViews = new TreeMap<RedisURI, TimedAsyncCommand<String, String, String>>(MasterSlaveUtils.RedisURIComparator.INSTANCE);
    private final List<RedisNodeDescription> nodes;

    public Requests(int expectedCount, List<RedisNodeDescription> nodes) {
        super(expectedCount);
        this.nodes = nodes;
    }

    protected void addRequest(RedisURI redisURI, TimedAsyncCommand<String, String, String> command) {
        this.rawViews.put(redisURI, command);
        command.onComplete((s, throwable) -> {
            if (throwable != null) {
                this.accept((Throwable)throwable);
            } else {
                this.accept(Tuples.of(redisURI, command));
            }
        });
    }

    @Override
    protected void onEmit(CompletableEventLatchSupport.Emission<List<RedisNodeDescription>> emission) {
        ArrayList<RedisNodeDescription> result = new ArrayList<RedisNodeDescription>();
        HashMap<RedisNodeDescription, Long> latencies = new HashMap<RedisNodeDescription, Long>();
        for (RedisNodeDescription node : this.nodes) {
            TimedAsyncCommand<String, String, String> future = this.getRequest(node.getUri());
            if (future == null || !future.isDone()) continue;
            RedisNodeDescription redisNodeDescription = MasterSlaveUtils.findNodeByUri(this.nodes, node.getUri());
            latencies.put(redisNodeDescription, future.duration());
            result.add(redisNodeDescription);
        }
        TopologyComparators.SortAction sortAction = TopologyComparators.SortAction.getSortAction();
        sortAction.sort(result, new TopologyComparators.LatencyComparator(latencies));
        emission.success(result);
    }

    protected Set<RedisURI> nodes() {
        return this.rawViews.keySet();
    }

    protected TimedAsyncCommand<String, String, String> getRequest(RedisURI redisURI) {
        return this.rawViews.get(redisURI);
    }
}

