/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterslave;

import io.lettuce.core.ConnectionFuture;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.Futures;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceLists;
import io.lettuce.core.masterslave.AutodiscoveryConnector;
import io.lettuce.core.masterslave.SentinelConnector;
import io.lettuce.core.masterslave.StatefulRedisMasterSlaveConnection;
import io.lettuce.core.masterslave.StaticMasterSlaveConnector;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

@Deprecated
public class MasterSlave {
    public static <K, V> StatefulRedisMasterSlaveConnection<K, V> connect(RedisClient redisClient, RedisCodec<K, V> codec, RedisURI redisURI) {
        LettuceAssert.notNull((Object)redisClient, "RedisClient must not be null");
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
        LettuceAssert.notNull((Object)redisURI, "RedisURI must not be null");
        return MasterSlave.getConnection(MasterSlave.connectAsyncSentinelOrAutodiscovery(redisClient, codec, redisURI), redisURI);
    }

    public static <K, V> CompletableFuture<StatefulRedisMasterSlaveConnection<K, V>> connectAsync(RedisClient redisClient, RedisCodec<K, V> codec, RedisURI redisURI) {
        return MasterSlave.transformAsyncConnectionException(MasterSlave.connectAsyncSentinelOrAutodiscovery(redisClient, codec, redisURI), redisURI);
    }

    private static <K, V> CompletableFuture<StatefulRedisMasterSlaveConnection<K, V>> connectAsyncSentinelOrAutodiscovery(RedisClient redisClient, RedisCodec<K, V> codec, RedisURI redisURI) {
        LettuceAssert.notNull((Object)redisClient, "RedisClient must not be null");
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
        LettuceAssert.notNull((Object)redisURI, "RedisURI must not be null");
        if (MasterSlave.isSentinel(redisURI)) {
            return new SentinelConnector<K, V>(redisClient, codec, redisURI).connectAsync();
        }
        return new AutodiscoveryConnector<K, V>(redisClient, codec, redisURI).connectAsync();
    }

    public static <K, V> StatefulRedisMasterSlaveConnection<K, V> connect(RedisClient redisClient, RedisCodec<K, V> codec, Iterable<RedisURI> redisURIs) {
        return MasterSlave.getConnection(MasterSlave.connectAsyncSentinelOrStaticSetup(redisClient, codec, redisURIs), redisURIs);
    }

    public static <K, V> CompletableFuture<StatefulRedisMasterSlaveConnection<K, V>> connectAsync(RedisClient redisClient, RedisCodec<K, V> codec, Iterable<RedisURI> redisURIs) {
        return MasterSlave.transformAsyncConnectionException(MasterSlave.connectAsyncSentinelOrStaticSetup(redisClient, codec, redisURIs), redisURIs);
    }

    private static <K, V> CompletableFuture<StatefulRedisMasterSlaveConnection<K, V>> connectAsyncSentinelOrStaticSetup(RedisClient redisClient, RedisCodec<K, V> codec, Iterable<RedisURI> redisURIs) {
        LettuceAssert.notNull((Object)redisClient, "RedisClient must not be null");
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
        LettuceAssert.notNull(redisURIs, "RedisURIs must not be null");
        List<RedisURI> uriList = LettuceLists.newList(redisURIs);
        LettuceAssert.isTrue(!uriList.isEmpty(), "RedisURIs must not be empty");
        RedisURI first = uriList.get(0);
        if (MasterSlave.isSentinel(first)) {
            if (uriList.size() > 1) {
                InternalLogger logger2 = InternalLoggerFactory.getInstance(MasterSlave.class);
                logger2.warn("RedisURIs contains multiple endpoints of which the first is configured for Sentinel usage. Using only the first {} without considering the remaining URIs. Make sure to include all Sentinel endpoints in a single RedisURI.", (Object)first);
            }
            return new SentinelConnector<K, V>(redisClient, codec, first).connectAsync();
        }
        return new StaticMasterSlaveConnector<K, V>(redisClient, codec, uriList).connectAsync();
    }

    private static boolean isSentinel(RedisURI redisURI) {
        return !redisURI.getSentinels().isEmpty();
    }

    private static <T> T getConnection(CompletableFuture<T> connectionFuture, Object context) {
        try {
            return connectionFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RedisConnectionException.create(context.toString(), (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                if (e.getCause() instanceof RedisConnectionException && e.getCause().getCause() instanceof RedisConnectionException) {
                    throw RedisConnectionException.create(context.toString(), e.getCause().getCause());
                }
                throw RedisConnectionException.create(context.toString(), e.getCause());
            }
            throw RedisConnectionException.create(context.toString(), (Throwable)e);
        }
    }

    private static <T> CompletableFuture<T> transformAsyncConnectionException(CompletionStage<T> future, Object context) {
        return ConnectionFuture.from(null, future.toCompletableFuture()).thenCompose((v, e) -> {
            if (e != null) {
                if (e.getCause() instanceof RedisConnectionException && e.getCause().getCause() instanceof RedisConnectionException) {
                    return Futures.failed(RedisConnectionException.create(context.toString(), e.getCause()));
                }
                return Futures.failed(RedisConnectionException.create(context.toString(), e));
            }
            return CompletableFuture.completedFuture(v);
        }).toCompletableFuture();
    }
}

