/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.sql;

import com.alibaba.fastjson.JSONArray;
import com.mugui.Mugui;
import com.mugui.bean.JsonBean;
import com.mugui.sql.DBConf;
import com.mugui.sql.JsonBeanAttr;
import com.mugui.sql.JsonBeanSQL;
import com.mugui.sql.SQLDB;
import com.mugui.sql.SqlModeApi;
import com.mugui.sql.SqlServer;
import com.mugui.sql.TableMode;
import com.mugui.sql.loader.Create;
import com.mugui.sql.loader.Delete;
import com.mugui.sql.loader.Insert;
import com.mugui.sql.loader.Select;
import com.mugui.sql.loader.Update;
import com.mugui.sql.loader.Where;
import com.mugui.sql.util.StringUtils;
import com.mugui.util.Other;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class SqlModel
implements Mugui,
SqlModeApi {
    private static final HashMap<String, Object> SQL_SERVER_MAP = new HashMap();

    public SqlServer getSqlServer() {
        return this.getSqlServer(DBConf.getDefaultDBConf().getUrl());
    }

    private <T extends JsonBean> SqlServer getSqlServer(T bean2) {
        return this.getSqlServer(bean2.getClass());
    }

    @Deprecated
    public SqlServer getSqlServer(String url) {
        if (url == null) {
            return new SqlServer();
        }
        SqlServer sqlServer = (SqlServer)SQL_SERVER_MAP.get(url);
        if (sqlServer == null) {
            sqlServer = new SqlServer(url);
            SQL_SERVER_MAP.put(url, sqlServer);
        }
        return sqlServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlServer getSqlServer(Class<? extends JsonBean> class1) {
        SQLDB object2 = (SQLDB)SQL_SERVER_MAP.get(class1.getName());
        if (object2 != null) {
            return (SqlServer)SQL_SERVER_MAP.get(object2.url());
        }
        Class<SqlModel> clazz = SqlModel.class;
        synchronized (SqlModel.class) {
            object2 = (SQLDB)SQL_SERVER_MAP.get(class1.getName());
            if (object2 != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return (SqlServer)SQL_SERVER_MAP.get(object2.url());
            }
            if (class1.isAnnotationPresent(SQLDB.class)) {
                SQLDB annotation = class1.getAnnotation(SQLDB.class);
                if (annotation.url().equals("")) {
                    SqlServer sqlServer = new SqlServer();
                    SQL_SERVER_MAP.put(annotation.url(), sqlServer);
                    SQL_SERVER_MAP.put(class1.getName(), annotation);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return sqlServer;
                }
                DBConf defaultConf = DBConf.getDefaultDBConf();
                DBConf dbConf = null;
                if (StringUtils.isBlank(annotation.url())) {
                    dbConf = defaultConf;
                } else {
                    dbConf = DBConf.getDBConf(annotation.url());
                    if (dbConf == null) {
                        String user = annotation.user().equals("") ? defaultConf.getUser() : annotation.user();
                        String pwd = annotation.pwd().equals("") ? defaultConf.getPwd() : annotation.pwd();
                        dbConf = new DBConf(defaultConf.getDrive(), annotation.url(), user, pwd);
                    }
                }
                SqlServer sqlServer = new SqlServer(dbConf.getUrl());
                SQL_SERVER_MAP.put(annotation.url(), sqlServer);
                SQL_SERVER_MAP.put(class1.getName(), annotation);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return sqlServer;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            throw new RuntimeException("\u8be5" + class1.getName() + " \u672a\u62e5\u6709sql\u914d\u7f6e");
        }
    }

    @Override
    public boolean clearTableData(Class<? extends JsonBean> class1) {
        JsonBeanAttr attr = JsonBeanAttr.getAttr(class1);
        System.out.println("clearTableData:" + attr.getTABLE());
        SqlServer sqlServer = this.getSqlServer();
        String clearSql = sqlServer.getSql("clear_table_data").replaceAll("<TABLE>", attr.getTABLE());
        return sqlServer.update(clearSql, new Object[0]);
    }

    @Override
    public void createTable(Class<? extends JsonBean> class1) {
        SQLDB description;
        if (class1.isAnnotationPresent(SQLDB.class) && !this.isTable((description = class1.getAnnotation(SQLDB.class)).TABLE())) {
            Create q = Create.q(class1);
            this.getSqlServer(class1).update(q.toString(), new Object[0]);
        }
    }

    @Override
    public boolean isTable(String TABLE) {
        TableMode tMode = this.getSqlServer().selectBy("is_table", TABLE);
        return tMode == null || tMode.getRowCount() == 1;
    }

    @Override
    public JSONArray getArray(TableMode tableMode) {
        return tableMode.getData();
    }

    @Override
    public <T extends JsonBean> List<T> getList(final TableMode tableMode, Class<T> beanClass) {
        LinkedList jsonArray = new LinkedList<T>(){
            private static final long serialVersionUID = 5464528312005612496L;

            @Override
            public String toString() {
                if (tableMode != null) {
                    return tableMode.getData().toJSONString();
                }
                return "{}";
            }
        };
        if (tableMode != null) {
            int j = 0;
            while (j < tableMode.getRowCount()) {
                jsonArray.add(this.get(tableMode, j, beanClass));
                ++j;
            }
        }
        return jsonArray;
    }

    @Override
    public <T extends JsonBean> T get(TableMode tm, int j, Class<T> beanClass) {
        if (tm == null) {
            return null;
        }
        if (tm.getRowCount() <= 0) {
            return null;
        }
        return (T)((JsonBean)JsonBean.newBean(beanClass, tm.getRowData(j)));
    }

    @Override
    public <T extends JsonBean> T save(T bean2) {
        Insert q;
        SqlServer server = this.getSqlServer(bean2);
        boolean bool = server.update((q = Insert.q(bean2)).toString(), q.getParameterArray());
        if (bool) {
            JsonBeanAttr attr = JsonBeanAttr.getAttr(bean2);
            if (bean2.get(attr.getKEY()) != null) {
                return this.get(bean2);
            }
            TableMode tMode = server.select(server.getSql("select_last_id").replaceAll("<TABLE>", "`" + attr.getTABLE() + "`"), new Object[0]);
            String i2 = tMode.getValueAt(0, 0);
            if (!Other.isInteger(i2) || Integer.parseInt(i2) == 0) {
                return bean2;
            }
            bean2.set(attr.getKEY(), Integer.parseInt(i2));
            return bean2;
        }
        throw new NullPointerException("save is ERROR:" + q.toString() + "\r\n" + "-->" + Arrays.toString(q.getParameterArray()));
    }

    @Override
    public boolean remove(JsonBean bean2) {
        Delete delete = JsonBeanSQL.delete(bean2);
        return this.getSqlServer(bean2).update(delete.toString(), delete.getParameterArray());
    }

    @Override
    public <T extends JsonBean> T get(T bean2) {
        JsonBeanAttr attr = JsonBeanAttr.getAttr(bean2);
        Select select = JsonBeanSQL.selectLoader(bean2).where(Where.q().and(attr.getKEY(), bean2.get(attr.getKEY())));
        return (T)this.select(bean2.getClass(), select);
    }

    @Override
    public <T extends JsonBean> T select(T bean2) {
        Select select = JsonBeanSQL.select(bean2);
        return (T)this.select(bean2.getClass(), select);
    }

    @Override
    public <T extends JsonBean> T select(Class<T> class1, Select select) {
        TableMode select2 = this.getSqlServer(class1).select(select.toString(), select.getParameterArray());
        return this.get(select2, 0, class1);
    }

    @Override
    public <T extends JsonBean> T select(Class<T> class1, JsonBean ... bean2) {
        Select select = JsonBeanSQL.select(bean2);
        return this.select(class1, select);
    }

    @Override
    public JSONArray selectArray(JsonBean bean2) {
        Select select = JsonBeanSQL.select(bean2);
        return this.selectArray(bean2.getClass(), select);
    }

    @Override
    public <T extends JsonBean> List<T> selectList(T bean2) {
        Select select = JsonBeanSQL.select(bean2);
        return this.selectList(bean2.getClass(), select);
    }

    @Override
    public <T extends JsonBean> List<T> selectList(Class<T> class1, JsonBean ... bean2) {
        Select select = JsonBeanSQL.select(bean2);
        return this.selectList(class1, select);
    }

    @Override
    public <T extends JsonBean> List<T> selectList(Class<T> class1, Select select) {
        TableMode select2 = this.getSqlServer(class1).select(select.toString(), select.getParameterArray());
        return this.getList(select2, class1);
    }

    @Override
    public JSONArray selectArray(Class<? extends JsonBean> class1, Select select) {
        TableMode select2 = this.getSqlServer(class1).select(select.toString(), select.getParameterArray());
        return this.getArray(select2);
    }

    @Override
    public <T extends JsonBean> boolean updata(T bean2) {
        Update update = JsonBeanSQL.update(bean2);
        return this.getSqlServer(bean2).update(update.toString(), update.getParameterArray());
    }

    @Override
    public <T extends JsonBean> Integer count(T bean2) {
        Select count = JsonBeanSQL.count(bean2);
        TableMode select = this.getSqlServer(bean2).select(count.toString(), count.getParameterArray());
        String valueAt = select.getValueAt(0, 0);
        if (valueAt == null) {
            return 0;
        }
        return Integer.parseInt(valueAt);
    }

    @Override
    public TableMode selectSql(String sql, Object ... objects) {
        return this.getSqlServer().select(sql, objects);
    }

    @Override
    public TableMode selectBy(String sql_name, Object ... objects) {
        return this.getSqlServer().selectBy(sql_name, objects);
    }

    @Override
    public boolean updateSql(String sql, Object ... objects) {
        return this.getSqlServer().update(sql, objects);
    }

    @Override
    public boolean updateBy(String sql_name, Object ... objects) {
        return this.getSqlServer().updateBy(sql_name, objects);
    }

    @Override
    public <T extends JsonBean> boolean updataByDifferential(T old, T New) {
        if (old.getClass() != New.getClass()) {
            throw new RuntimeException("\u9519\u8bef\u7684\u53c2\u6570 " + old.getClass().getName() + " " + New.getClass().getName());
        }
        New = (JsonBean)JsonBean.newBean(New.getClass(), New);
        JsonBeanAttr attr = JsonBeanAttr.getAttr(old);
        List<Field> fieldAttr = attr.getFields();
        for (Field field : fieldAttr) {
            if (field == fieldAttr.get(0)) continue;
            Class<?> class1 = field.getType();
            Object object = old.get(field.getName());
            if (object == null) continue;
            try {
                Object new_Object = field.get(New);
                if (object.equals(new_Object)) {
                    field.set(New, null);
                    continue;
                }
                if (class1 == Integer.TYPE || class1 == Integer.class) {
                    field.set(New, (Integer)new_Object - (Integer)object);
                    continue;
                }
                if (class1 != BigDecimal.class) continue;
                field.set(New, ((BigDecimal)field.get(New)).subtract((BigDecimal)object));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        Update update = Update.increment((JsonBean)New);
        return this.getSqlServer().update(update.toString(), update.getParameterArray());
    }

    @Override
    public <T extends JsonBean> T selectDESC(T bean2) {
        Select where = JsonBeanSQL.select(bean2).where(Where.q().orderByDESCKeyId(bean2));
        return (T)this.select(bean2.getClass(), where);
    }

    @Override
    public <T extends JsonBean> T selectDESC(Class<T> class1, JsonBean ... bean2) {
        Select where = JsonBeanSQL.select(bean2).where(Where.q().orderByDESCKeyId(bean2[0]));
        return this.select(class1, where);
    }

    @Override
    public <T extends JsonBean> JSONArray selectArrayDESC(T bean2) {
        Select where = JsonBeanSQL.select(bean2).where(Where.q().orderByDESCKeyId(bean2));
        return this.selectArray(bean2.getClass(), where);
    }

    @Override
    public <T extends JsonBean> JSONArray selectArrayDESC(Class<T> class1, JsonBean ... bean2) {
        Select where = JsonBeanSQL.select(bean2).where(Where.q().orderByDESCKeyId(bean2[0]));
        return this.selectArray(class1, where);
    }

    @Override
    public <T extends JsonBean> JSONArray selectArrayDESC(Class<T> class1, String desc_name, JsonBean ... bean2) {
        Select where = JsonBeanSQL.select(bean2).where(Where.q().orderByDESC(desc_name));
        return this.selectArray(class1, where);
    }

    @Override
    public <T extends JsonBean> List<T> selectListDESC(T bean2) {
        Select where = JsonBeanSQL.select(bean2).where(Where.q().orderByDESCKeyId(bean2));
        return this.selectList(bean2.getClass(), where);
    }

    @Override
    public <T extends JsonBean> List<T> selectListDESC(Class<T> class1, JsonBean ... bean2) {
        Select where = JsonBeanSQL.select(bean2).where(Where.q().orderByDESCKeyId(bean2[0]));
        return this.selectList(class1, where);
    }

    @Override
    public <T extends JsonBean> T selectDESC(T bean2, String desc_name) {
        Select where = JsonBeanSQL.select(bean2).where(Where.q().orderByDESC(desc_name));
        return (T)this.select(bean2.getClass(), where);
    }

    @Override
    public <T extends JsonBean> List<T> selectListDESC(T bean2, String desc_name) {
        Select where = JsonBeanSQL.select(bean2).where(Where.q().orderByDESC(desc_name));
        return this.selectList(bean2.getClass(), where);
    }

    @Override
    public <T extends JsonBean> List<T> selectListDESC(Class<T> class1, String desc_name, JsonBean ... bean2) {
        Select where = JsonBeanSQL.select(bean2).where(Where.q().orderByDESC(desc_name));
        return this.selectList(class1, where);
    }

    @Override
    public <T extends JsonBean> T selectDESC(Class<T> class1, String desc_name, JsonBean ... bean2) {
        Select where = JsonBeanSQL.select(bean2).where(Where.q().orderByDESC(desc_name));
        return this.select(class1, where);
    }
}

