/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.spring.net.baghandle;

import com.mugui.Mugui;
import com.mugui.spring.base.Cache;
import com.mugui.spring.base.Filter;
import com.mugui.spring.base.Listener;
import com.mugui.spring.base.ModelInterface;
import com.mugui.spring.base.Module;
import com.mugui.spring.net.baghandle.NetBagModuleManager;
import com.mugui.spring.net.bean.Message;
import com.mugui.spring.net.bean.NetBag;
import com.mugui.spring.net.cache.CacheModel;
import com.mugui.spring.net.filter.FilterModel;
import com.mugui.spring.net.listener.ListenerModel;
import com.mugui.spring.net.lock.NetBagHandle;
import com.mugui.spring.net.lock.SynchronizeLock;
import com.mugui.spring.net.sys.SysLogManager;
import com.mugui.spring.util.RedisAccess;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.web.multipart.MultipartFile;

public class NetBagModule
implements ModelInterface {
    private NetBagModuleManager manager = null;
    private ApplicationContext applicationContext = null;
    public SysLogManager dataManager = null;
    public RedisAccess redisAccess = null;
    private String appliction_name = "\u672a\u547d\u540d";
    private HashMap<String, List<FilterModel>> filterMap = new HashMap();
    private HashMap<String, List<ListenerModel>> listenerMap = new HashMap();
    private HashMap<String, List<CacheModel>> cacheMap = new HashMap();
    private HashMap<String, Method> methods = new HashMap();
    Mugui object = null;
    Module module = null;
    private static boolean listener_sys_info = false;
    private static boolean listener_sys_error = false;
    private static long time = 0L;
    private ThreadLocal<List<CacheModel>> cacheLocal = new ThreadLocal();

    @Override
    public void stop() {
    }

    @Override
    public void start() {
    }

    @Override
    public boolean isrun() {
        return false;
    }

    @Override
    public void init() {
        if (this.applicationContext == null) {
            this.applicationContext = (ApplicationContext)System.getProperties().get("Application");
        }
        if (this.applicationContext != null) {
            this.manager = this.applicationContext.getBean(NetBagModuleManager.class);
        }
        if (this.manager == null) {
            throw new RuntimeException("\u542f\u52a8\u9519\u8bef\uff1a" + NetBagModuleManager.class + " \u672a\u521d\u59cb\u5316");
        }
    }

    public void init(Module module, Mugui obj) {
        this.init();
        this.module = module;
        this.object = (Mugui)this.applicationContext.getBean(obj.getClass());
        this.dataManager = this.applicationContext.getBean(SysLogManager.class);
        this.dataManager.init(null);
        this.redisAccess = this.applicationContext.getBean(RedisAccess.class);
        this.appliction_name = this.applicationContext.getEnvironment().getProperty("spring.application.name");
        if (StringUtils.isBlank(this.appliction_name)) {
            this.appliction_name = "\u672a\u547d\u540d";
        }
        this.initMethods();
    }

    private void initMethods() {
        Method[] methods2;
        Method[] methodArray = methods2 = this.object.getClass().getMethods();
        int n = methods2.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            method.setAccessible(true);
            this.methods.put(method.getName(), method);
            ++n2;
        }
    }

    private boolean handleFilterModel(String string, FilterModel filterModel) {
        Filter filter2 = filterModel.getClass().getAnnotation(Filter.class);
        String[] values = filter2.value();
        boolean b = filter2.type() != 0;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            boolean bool = string.matches(value.replaceAll("[*]", "[a-z A-Z 0-9 .]*"));
            switch (filter2.type()) {
                case 0: {
                    if (!bool) break;
                    return true;
                }
                case 1: {
                    if (!bool) break;
                    return false;
                }
            }
            ++n2;
        }
        return b;
    }

    private boolean handleListenerModel(String string, ListenerModel listenerModel) {
        Listener listener = listenerModel.getClass().getAnnotation(Listener.class);
        String[] values = listener.value();
        boolean b = listener.type() != 0;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            boolean bool = string.matches(value.replaceAll("[*]", "[a-z A-Z 0-9 .]*"));
            switch (listener.type()) {
                case 0: {
                    if (!bool) break;
                    return true;
                }
                case 1: {
                    if (!bool) break;
                    return false;
                }
            }
            ++n2;
        }
        return b;
    }

    private boolean handleCacheModel(String string, CacheModel cacheModel) {
        Cache listener = cacheModel.getClass().getAnnotation(Cache.class);
        String[] values = listener.value();
        boolean b = listener.type() != 0;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            boolean bool = string.matches(value.replaceAll("[*]", "[a-z A-Z 0-9 .]*"));
            switch (listener.type()) {
                case 0: {
                    if (!bool) break;
                    return true;
                }
                case 1: {
                    if (!bool) break;
                    return false;
                }
            }
            ++n2;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public NetBag runFunc(NetBag bag, MultipartFile[] files) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        NetBag handleAddForward;
        if (files != null) {
            bag.get().put("uploadFile", (Object)files);
        }
        if (System.currentTimeMillis() - time > 10000L) {
            Class<NetBagModule> clazz = NetBagModule.class;
            // MONITORENTER : com.mugui.spring.net.baghandle.NetBagModule.class
            if (System.currentTimeMillis() - time > 10000L) {
                time = System.currentTimeMillis();
                listener_sys_info = "true".equals(this.redisAccess.get("listener_sys_info"));
                listener_sys_error = "true".equals(this.redisAccess.get("listener_sys_error"));
            }
            // MONITOREXIT : clazz
        }
        if ((handleAddForward = this.handleAddForward(bag)) != null) {
            return handleAddForward;
        }
        NetBag handleAddFilter = this.handleAddFilter(bag);
        if (handleAddFilter != null) {
            return handleAddFilter;
        }
        Message data = null;
        try {
            Method method;
            NetBag handleAddCache = this.handleAddCache(bag);
            if (handleAddCache != null) {
                NetBag netBag = handleAddCache;
                return netBag;
            }
            String[] func = bag.getFunc().split("[.]");
            if (listener_sys_info) {
                this.dataManager.NetbagLog().info(this.appliction_name, bag);
            }
            if ((method = this.methods.get(func[func.length - 1])) == null) {
                throw new RuntimeException(String.valueOf(this.object.getClass().getName()) + " not find " + func[func.length - 1]);
            }
            data = (Message)method.invoke((Object)this.object, bag);
            if (listener_sys_info) {
                this.dataManager.NetbagLog().info(this.appliction_name, bag, data);
            }
            this.saveCache(data, bag);
            bag.setCode(200);
            bag.setData(data);
            NetBag netBag = bag;
            this.handleAddListener(bag, data);
            return netBag;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (listener_sys_error) {
                this.dataManager.NetbagLog().error(this.appliction_name, bag, e);
            }
            bag.setCode(503);
            bag.setData(Message.error("\u6570\u636e\u4f20\u8f93\u9519\u8bef"));
            NetBag netBag = bag;
            return netBag;
        }
        finally {
            this.handleAddListener(bag, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAddListener(NetBag bag, Message data) {
        List<ListenerModel> listenerModels = null;
        listenerModels = this.listenerMap.get(bag.getFunc());
        if (listenerModels == null) {
            HashMap<String, List<ListenerModel>> hashMap = this.listenerMap;
            synchronized (hashMap) {
                listenerModels = this.listenerMap.get(bag.getFunc());
                if (listenerModels == null) {
                    listenerModels = new LinkedList<ListenerModel>();
                    this.listenerMap.put(bag.getFunc(), listenerModels);
                    if (this.manager.getListenerMessage() != null) {
                        for (Map.Entry<String, ListenerModel> entry : this.manager.getListenerMessage().entrySet()) {
                            String string = bag.getFunc();
                            boolean bool = this.handleListenerModel(string, entry.getValue());
                            if (!bool) continue;
                            listenerModels.add(entry.getValue());
                        }
                        listenerModels.sort(new Comparator<ListenerModel>(){

                            @Override
                            public int compare(ListenerModel o1, ListenerModel o2) {
                                Listener filter1 = o1.getClass().getAnnotation(Listener.class);
                                Listener filter2 = o2.getClass().getAnnotation(Listener.class);
                                return filter1.weight() - filter2.weight();
                            }
                        });
                    }
                }
            }
        }
        for (ListenerModel model : listenerModels) {
            try {
                if (listener_sys_info) {
                    this.dataManager.ListenerLog().info(this.appliction_name, bag, data);
                }
                model.listener(data, bag);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!listener_sys_error) continue;
                this.dataManager.ListenerLog().error(this.appliction_name, bag, data, e);
            }
        }
    }

    private void saveCache(Message data, NetBag bag) {
        List<CacheModel> cacheModels = this.cacheLocal.get();
        for (CacheModel model : cacheModels) {
            try {
                if (listener_sys_info) {
                    this.dataManager.CacheLog().info(this.appliction_name, bag, data);
                }
                model.save(data, bag);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!listener_sys_error) continue;
                this.dataManager.CacheLog().error(this.appliction_name, bag, data, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetBag handleAddCache(NetBag bag) {
        List<CacheModel> cacheModels = null;
        cacheModels = this.cacheMap.get(bag.getFunc());
        if (cacheModels == null) {
            HashMap<String, List<CacheModel>> hashMap = this.cacheMap;
            synchronized (hashMap) {
                cacheModels = this.cacheMap.get(bag.getFunc());
                if (cacheModels == null) {
                    cacheModels = new LinkedList<CacheModel>();
                    this.cacheMap.put(bag.getFunc(), cacheModels);
                    if (this.manager.getCacheMessage() != null) {
                        for (Map.Entry<String, CacheModel> entry : this.manager.getCacheMessage().entrySet()) {
                            String string = bag.getFunc();
                            boolean bool = this.handleCacheModel(string, entry.getValue());
                            if (!bool) continue;
                            cacheModels.add(entry.getValue());
                        }
                    }
                }
            }
        }
        this.cacheLocal.set(cacheModels);
        for (CacheModel model : cacheModels) {
            try {
                if (listener_sys_info) {
                    this.dataManager.CacheLog().info(this.appliction_name, bag);
                }
                if (model.load(bag) != null) continue;
                if (listener_sys_info) {
                    this.dataManager.CacheLog().info(this.appliction_name, bag);
                }
                return bag;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!listener_sys_error) continue;
                this.dataManager.CacheLog().error(this.appliction_name, bag, e);
            }
        }
        if (listener_sys_info) {
            this.dataManager.CacheLog().info(this.appliction_name, bag, "");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetBag handleAddFilter(NetBag bag) {
        List<FilterModel> filterModels = null;
        filterModels = this.filterMap.get(bag.getFunc());
        if (filterModels == null) {
            HashMap<String, List<FilterModel>> hashMap = this.filterMap;
            synchronized (hashMap) {
                filterModels = this.filterMap.get(bag.getFunc());
                if (filterModels == null) {
                    filterModels = new LinkedList<FilterModel>();
                    this.filterMap.put(bag.getFunc(), filterModels);
                    if (this.manager.getFilterMessage() != null) {
                        for (Map.Entry<String, FilterModel> entry : this.manager.getFilterMessage().entrySet()) {
                            String string = bag.getFunc();
                            boolean bool = this.handleFilterModel(string, entry.getValue());
                            if (!bool) continue;
                            filterModels.add(entry.getValue());
                        }
                        filterModels.sort(new Comparator<FilterModel>(){

                            @Override
                            public int compare(FilterModel o1, FilterModel o2) {
                                Filter filter1 = o1.getClass().getAnnotation(Filter.class);
                                Filter filter2 = o2.getClass().getAnnotation(Filter.class);
                                return filter2.weight() - filter1.weight();
                            }
                        });
                    }
                }
            }
        }
        for (FilterModel model : filterModels) {
            try {
                if (listener_sys_info) {
                    this.dataManager.FilterLog().info(this.appliction_name, bag);
                }
                if (model.filter(bag) != null) continue;
                this.applicationContext.getBean(NetBagHandle.class).listener(null, bag);
                this.applicationContext.getBean(SynchronizeLock.class).listener(null, bag);
                return bag;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!listener_sys_error) continue;
                this.dataManager.FilterLog().error(this.appliction_name, bag, e);
            }
        }
        return null;
    }

    private NetBag handleAddForward(NetBag bag) {
        String[] func = bag.getFunc().split("[.]");
        if (bag.getFunc().startsWith("&forward.insert.")) {
            Message message;
            block5: {
                message = null;
                try {
                    if (listener_sys_info) {
                        this.dataManager.ForwardLog().info(this.appliction_name, bag);
                    }
                    message = (Message)this.object.invokeFunction(func[func.length - 1], bag);
                    if (listener_sys_info) {
                        this.dataManager.ForwardLog().info(this.appliction_name, bag, message);
                    }
                }
                catch (Exception e) {
                    message.setDate(e.getMessage());
                    if (!listener_sys_error) break block5;
                    this.dataManager.ForwardLog().error(this.appliction_name, bag, message, e);
                }
            }
            bag.setCode(200);
            bag.setData(message);
            return bag;
        }
        return null;
    }
}

