/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.utils;

import com.alibaba.nacos.api.common.Constants;

public class ContentUtils {
    private static int SHOW_CONTENT_SIZE = 100;

    public static void verifyIncrementPubContent(String content) {
        if (content == null || content.length() == 0) {
            throw new IllegalArgumentException("\u53d1\u5e03/\u5220\u9664\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (int i2 = 0; i2 < content.length(); ++i2) {
            char c = content.charAt(i2);
            if (c == '\r' || c == '\n') {
                throw new IllegalArgumentException("\u53d1\u5e03/\u5220\u9664\u5185\u5bb9\u4e0d\u80fd\u5305\u542b\u56de\u8f66\u548c\u6362\u884c");
            }
            if (c != Constants.WORD_SEPARATOR.charAt(0)) continue;
            throw new IllegalArgumentException("\u53d1\u5e03/\u5220\u9664\u5185\u5bb9\u4e0d\u80fd\u5305\u542b(char)2");
        }
    }

    public static String getContentIdentity(String content) {
        int index = content.indexOf(Constants.WORD_SEPARATOR);
        if (index == -1) {
            throw new IllegalArgumentException("\u5185\u5bb9\u6ca1\u6709\u5305\u542b\u5206\u9694\u7b26");
        }
        return content.substring(0, index);
    }

    public static String getContent(String content) {
        int index = content.indexOf(Constants.WORD_SEPARATOR);
        if (index == -1) {
            throw new IllegalArgumentException("\u5185\u5bb9\u6ca1\u6709\u5305\u542b\u5206\u9694\u7b26");
        }
        return content.substring(index + 1);
    }

    public static String truncateContent(String content) {
        if (content == null) {
            return "";
        }
        if (content.length() <= SHOW_CONTENT_SIZE) {
            return content;
        }
        return content.substring(0, SHOW_CONTENT_SIZE) + "...";
    }
}

