/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.com.caucho.hessian.io;

import com.alibaba.com.caucho.hessian.io.AbstractHessianInput;
import com.alibaba.com.caucho.hessian.io.AbstractListDeserializer;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class ArrayDeserializer
extends AbstractListDeserializer {
    private Class _componentType;
    private Class _type;

    public ArrayDeserializer(Class componentType) {
        this._componentType = componentType;
        if (this._componentType != null) {
            try {
                this._type = Array.newInstance(this._componentType, 0).getClass();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._type == null) {
            this._type = Object[].class;
        }
    }

    @Override
    public Class getType() {
        return this._type;
    }

    @Override
    public Object readList(AbstractHessianInput in, int length) throws IOException {
        if (length >= 0) {
            Object[] data = this.createArray(length);
            in.addRef(data);
            if (this._componentType != null) {
                for (int i2 = 0; i2 < data.length; ++i2) {
                    data[i2] = in.readObject(this._componentType);
                }
            } else {
                for (int i3 = 0; i3 < data.length; ++i3) {
                    data[i3] = in.readObject();
                }
            }
            in.readListEnd();
            return data;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        in.addRef(list);
        if (this._componentType != null) {
            while (!in.isEnd()) {
                list.add(in.readObject(this._componentType));
            }
        } else {
            while (!in.isEnd()) {
                list.add(in.readObject());
            }
        }
        in.readListEnd();
        Object[] data = this.createArray(list.size());
        for (int i4 = 0; i4 < data.length; ++i4) {
            data[i4] = list.get(i4);
        }
        return data;
    }

    @Override
    public Object readLengthList(AbstractHessianInput in, int length) throws IOException {
        Object[] data = this.createArray(length);
        in.addRef(data);
        if (this._componentType != null) {
            for (int i2 = 0; i2 < data.length; ++i2) {
                data[i2] = in.readObject(this._componentType);
            }
        } else {
            for (int i3 = 0; i3 < data.length; ++i3) {
                data[i3] = in.readObject();
            }
        }
        return data;
    }

    protected Object[] createArray(int length) {
        if (this._componentType != null) {
            return (Object[])Array.newInstance(this._componentType, length);
        }
        return new Object[length];
    }

    public String toString() {
        return "ArrayDeserializer[" + this._componentType + "]";
    }
}

