/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.util.IOUtils;
import redis.clients.jedis.util.RedisInputStream;
import redis.clients.jedis.util.RedisOutputStream;
import redis.clients.jedis.util.SafeEncoder;

public class Connection
implements Closeable {
    private static final byte[][] EMPTY_ARGS = new byte[0][];
    private String host = "localhost";
    private int port = 6379;
    private Socket socket;
    private RedisOutputStream outputStream;
    private RedisInputStream inputStream;
    private int connectionTimeout = 2000;
    private int soTimeout = 2000;
    private boolean broken = false;
    private boolean ssl;
    private SSLSocketFactory sslSocketFactory;
    private SSLParameters sslParameters;
    private HostnameVerifier hostnameVerifier;

    public Connection() {
    }

    public Connection(String host) {
        this.host = host;
    }

    public Connection(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public Connection(String host, int port, boolean ssl) {
        this.host = host;
        this.port = port;
        this.ssl = ssl;
    }

    public Connection(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this.host = host;
        this.port = port;
        this.ssl = ssl;
        this.sslSocketFactory = sslSocketFactory;
        this.sslParameters = sslParameters;
        this.hostnameVerifier = hostnameVerifier;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setTimeoutInfinite() {
        try {
            if (!this.isConnected()) {
                this.connect();
            }
            this.socket.setSoTimeout(0);
        }
        catch (SocketException ex) {
            this.broken = true;
            throw new JedisConnectionException(ex);
        }
    }

    public void rollbackTimeout() {
        try {
            this.socket.setSoTimeout(this.soTimeout);
        }
        catch (SocketException ex) {
            this.broken = true;
            throw new JedisConnectionException(ex);
        }
    }

    public void sendCommand(ProtocolCommand cmd, String ... args) {
        byte[][] bargs = new byte[args.length][];
        for (int i2 = 0; i2 < args.length; ++i2) {
            bargs[i2] = SafeEncoder.encode(args[i2]);
        }
        this.sendCommand(cmd, bargs);
    }

    public void sendCommand(ProtocolCommand cmd) {
        this.sendCommand(cmd, EMPTY_ARGS);
    }

    public void sendCommand(ProtocolCommand cmd, byte[] ... args) {
        try {
            this.connect();
            Protocol.sendCommand(this.outputStream, cmd, args);
        }
        catch (JedisConnectionException ex) {
            try {
                String errorMessage = Protocol.readErrorLineIfPossible(this.inputStream);
                if (errorMessage != null && errorMessage.length() > 0) {
                    ex = new JedisConnectionException(errorMessage, ex.getCause());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.broken = true;
            throw ex;
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void connect() {
        if (!this.isConnected()) {
            try {
                this.socket = new Socket();
                this.socket.setReuseAddress(true);
                this.socket.setKeepAlive(true);
                this.socket.setTcpNoDelay(true);
                this.socket.setSoLinger(true, 0);
                this.socket.connect(new InetSocketAddress(this.host, this.port), this.connectionTimeout);
                this.socket.setSoTimeout(this.soTimeout);
                if (this.ssl) {
                    if (null == this.sslSocketFactory) {
                        this.sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    }
                    this.socket = this.sslSocketFactory.createSocket(this.socket, this.host, this.port, true);
                    if (null != this.sslParameters) {
                        ((SSLSocket)this.socket).setSSLParameters(this.sslParameters);
                    }
                    if (null != this.hostnameVerifier && !this.hostnameVerifier.verify(this.host, ((SSLSocket)this.socket).getSession())) {
                        String message = String.format("The connection to '%s' failed ssl/tls hostname verification.", this.host);
                        throw new JedisConnectionException(message);
                    }
                }
                this.outputStream = new RedisOutputStream(this.socket.getOutputStream());
                this.inputStream = new RedisInputStream(this.socket.getInputStream());
            }
            catch (IOException ex) {
                this.broken = true;
                throw new JedisConnectionException("Failed connecting to host " + this.host + ":" + this.port, ex);
            }
        }
    }

    @Override
    public void close() {
        this.disconnect();
    }

    public void disconnect() {
        if (this.isConnected()) {
            try {
                this.outputStream.flush();
                this.socket.close();
            }
            catch (IOException ex) {
                this.broken = true;
                throw new JedisConnectionException(ex);
            }
            finally {
                IOUtils.closeQuietly(this.socket);
            }
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isBound() && !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    public String getStatusCodeReply() {
        this.flush();
        byte[] resp = (byte[])this.readProtocolWithCheckingBroken();
        if (null == resp) {
            return null;
        }
        return SafeEncoder.encode(resp);
    }

    public String getBulkReply() {
        byte[] result = this.getBinaryBulkReply();
        if (null != result) {
            return SafeEncoder.encode(result);
        }
        return null;
    }

    public byte[] getBinaryBulkReply() {
        this.flush();
        return (byte[])this.readProtocolWithCheckingBroken();
    }

    public Long getIntegerReply() {
        this.flush();
        return (Long)this.readProtocolWithCheckingBroken();
    }

    public List<String> getMultiBulkReply() {
        return BuilderFactory.STRING_LIST.build(this.getBinaryMultiBulkReply());
    }

    public List<byte[]> getBinaryMultiBulkReply() {
        this.flush();
        return (List)this.readProtocolWithCheckingBroken();
    }

    @Deprecated
    public List<Object> getRawObjectMultiBulkReply() {
        return this.getUnflushedObjectMultiBulkReply();
    }

    public List<Object> getUnflushedObjectMultiBulkReply() {
        return (List)this.readProtocolWithCheckingBroken();
    }

    public List<Object> getObjectMultiBulkReply() {
        this.flush();
        return this.getUnflushedObjectMultiBulkReply();
    }

    public List<Long> getIntegerMultiBulkReply() {
        this.flush();
        return (List)this.readProtocolWithCheckingBroken();
    }

    public Object getOne() {
        this.flush();
        return this.readProtocolWithCheckingBroken();
    }

    public boolean isBroken() {
        return this.broken;
    }

    protected void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException ex) {
            this.broken = true;
            throw new JedisConnectionException(ex);
        }
    }

    protected Object readProtocolWithCheckingBroken() {
        if (this.broken) {
            throw new JedisConnectionException("Attempting to read from a broken connection");
        }
        try {
            return Protocol.read(this.inputStream);
        }
        catch (JedisConnectionException exc) {
            this.broken = true;
            throw exc;
        }
    }

    public List<Object> getMany(int count) {
        this.flush();
        ArrayList<Object> responses = new ArrayList<Object>(count);
        for (int i2 = 0; i2 < count; ++i2) {
            try {
                responses.add(this.readProtocolWithCheckingBroken());
                continue;
            }
            catch (JedisDataException e) {
                responses.add(e);
            }
        }
        return responses;
    }
}

