/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortArgumentResolver;
import org.springframework.data.web.SortHandlerMethodArgumentResolverSupport;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class SortHandlerMethodArgumentResolver
extends SortHandlerMethodArgumentResolverSupport
implements SortArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return Sort.class.equals(parameter.getParameterType());
    }

    @Override
    public Sort resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) {
        String[] directionParameter = webRequest.getParameterValues(this.getSortParameter(parameter));
        if (directionParameter == null) {
            return this.getDefaultFromAnnotationOrFallback(parameter);
        }
        if (directionParameter.length == 1 && !StringUtils.hasText(directionParameter[0])) {
            return this.getDefaultFromAnnotationOrFallback(parameter);
        }
        return this.parseParameterIntoSort(Arrays.asList(directionParameter), this.getPropertyDelimiter());
    }
}

