/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ProcessBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.redis.core.RedisKeyValueAdapter;
import org.springframework.data.redis.core.RedisKeyValueTemplate;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.repository.cdi.RedisKeyValueAdapterBean;
import org.springframework.data.redis.repository.cdi.RedisKeyValueTemplateBean;
import org.springframework.data.redis.repository.cdi.RedisRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryExtensionSupport;

public class RedisRepositoryExtension
extends CdiRepositoryExtensionSupport {
    private final Log log = LogFactory.getLog(RedisRepositoryExtension.class);
    private final Map<Set<Annotation>, Bean<RedisKeyValueAdapter>> redisKeyValueAdapters = new HashMap<Set<Annotation>, Bean<RedisKeyValueAdapter>>();
    private final Map<Set<Annotation>, Bean<KeyValueOperations>> redisKeyValueTemplates = new HashMap<Set<Annotation>, Bean<KeyValueOperations>>();
    private final Map<Set<Annotation>, Bean<RedisOperations<?, ?>>> redisOperations = new HashMap();

    public RedisRepositoryExtension() {
        this.log.info("Activating CDI extension for Spring Data Redis repositories.");
    }

    <X> void processBean(@Observes ProcessBean<X> processBean) {
        Bean bean2 = processBean.getBean();
        for (Type type : bean2.getTypes()) {
            Type beanType = type;
            if (beanType instanceof ParameterizedType) {
                beanType = ((ParameterizedType)beanType).getRawType();
            }
            if (beanType instanceof Class && RedisKeyValueTemplate.class.isAssignableFrom((Class)beanType)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("Discovered %s with qualifiers %s.", RedisKeyValueTemplate.class.getName(), bean2.getQualifiers()));
                }
                this.redisKeyValueTemplates.put(new HashSet(bean2.getQualifiers()), (Bean<KeyValueOperations>)bean2);
            }
            if (beanType instanceof Class && RedisKeyValueAdapter.class.isAssignableFrom((Class)beanType)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("Discovered %s with qualifiers %s.", RedisKeyValueAdapter.class.getName(), bean2.getQualifiers()));
                }
                this.redisKeyValueAdapters.put(new HashSet(bean2.getQualifiers()), (Bean<RedisKeyValueAdapter>)bean2);
            }
            if (!(beanType instanceof Class) || !RedisOperations.class.isAssignableFrom((Class)beanType)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Discovered %s with qualifiers %s.", RedisOperations.class.getName(), bean2.getQualifiers()));
            }
            this.redisOperations.put(new HashSet(bean2.getQualifiers()), bean2);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        this.registerDependenciesIfNecessary(afterBeanDiscovery, beanManager);
        for (Map.Entry<Class<?>, Set<Annotation>> entry : this.getRepositoryTypes()) {
            Class<?> repositoryType = entry.getKey();
            Set<Annotation> qualifiers = entry.getValue();
            CdiRepositoryBean<?> repositoryBean = this.createRepositoryBean(repositoryType, qualifiers, beanManager);
            if (this.log.isInfoEnabled()) {
                this.log.info(String.format("Registering bean for %s with qualifiers %s.", repositoryType.getName(), qualifiers));
            }
            this.registerBean(repositoryBean);
            afterBeanDiscovery.addBean(repositoryBean);
        }
    }

    private void registerDependenciesIfNecessary(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (Map.Entry<Class<?>, Set<Annotation>> entry : this.getRepositoryTypes()) {
            Set<Annotation> qualifiers = entry.getValue();
            if (!this.redisKeyValueAdapters.containsKey(qualifiers)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info(String.format("Registering bean for %s with qualifiers %s.", RedisKeyValueAdapter.class.getName(), qualifiers));
                }
                RedisKeyValueAdapterBean redisKeyValueAdapterBean = this.createRedisKeyValueAdapterBean(qualifiers, beanManager);
                this.redisKeyValueAdapters.put(qualifiers, redisKeyValueAdapterBean);
                afterBeanDiscovery.addBean((Bean)redisKeyValueAdapterBean);
            }
            if (this.redisKeyValueTemplates.containsKey(qualifiers)) continue;
            if (this.log.isInfoEnabled()) {
                this.log.info(String.format("Registering bean for %s with qualifiers %s.", RedisKeyValueTemplate.class.getName(), qualifiers));
            }
            RedisKeyValueTemplateBean redisKeyValueTemplateBean = this.createRedisKeyValueTemplateBean(qualifiers, beanManager);
            this.redisKeyValueTemplates.put(qualifiers, redisKeyValueTemplateBean);
            afterBeanDiscovery.addBean((Bean)redisKeyValueTemplateBean);
        }
    }

    private <T> CdiRepositoryBean<T> createRepositoryBean(Class<T> repositoryType, Set<Annotation> qualifiers, BeanManager beanManager) {
        Bean<KeyValueOperations> redisKeyValueTemplate = this.redisKeyValueTemplates.get(qualifiers);
        if (redisKeyValueTemplate == null) {
            throw new UnsatisfiedResolutionException(String.format("Unable to resolve a bean for '%s' with qualifiers %s.", RedisKeyValueTemplate.class.getName(), qualifiers));
        }
        return new RedisRepositoryBean<T>(redisKeyValueTemplate, qualifiers, repositoryType, beanManager, this.getCustomImplementationDetector());
    }

    private RedisKeyValueAdapterBean createRedisKeyValueAdapterBean(Set<Annotation> qualifiers, BeanManager beanManager) {
        Bean<RedisOperations<?, ?>> redisOperationsBean = this.redisOperations.get(qualifiers);
        if (redisOperationsBean == null) {
            throw new UnsatisfiedResolutionException(String.format("Unable to resolve a bean for '%s' with qualifiers %s.", RedisOperations.class.getName(), qualifiers));
        }
        return new RedisKeyValueAdapterBean(redisOperationsBean, qualifiers, beanManager);
    }

    private RedisKeyValueTemplateBean createRedisKeyValueTemplateBean(Set<Annotation> qualifiers, BeanManager beanManager) {
        Bean<RedisKeyValueAdapter> redisKeyValueAdapterBean = this.redisKeyValueAdapters.get(qualifiers);
        if (redisKeyValueAdapterBean == null) {
            throw new UnsatisfiedResolutionException(String.format("Unable to resolve a bean for '%s' with qualifiers %s.", RedisKeyValueAdapter.class.getName(), qualifiers));
        }
        return new RedisKeyValueTemplateBean(redisKeyValueAdapterBean, qualifiers, beanManager);
    }
}

