/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.util.Assert;

public final class StreamOffset<K> {
    private final K key;
    private final ReadOffset offset;

    private StreamOffset(K key, ReadOffset offset) {
        Assert.notNull(key, "Key must not be null");
        Assert.notNull((Object)offset, "ReadOffset must not be null");
        this.key = key;
        this.offset = offset;
    }

    public static <K> StreamOffset<K> create(K stream, ReadOffset readOffset) {
        return new StreamOffset<K>(stream, readOffset);
    }

    public static <K> StreamOffset<K> latest(K stream) {
        return new StreamOffset<K>(stream, ReadOffset.latest());
    }

    public static <K> StreamOffset<K> fromStart(K stream) {
        return new StreamOffset<K>(stream, ReadOffset.from("0-0"));
    }

    public static <K> StreamOffset<K> from(Record<K, ?> reference) {
        Assert.notNull(reference, "Reference record must not be null");
        return StreamOffset.create(reference.getStream(), ReadOffset.from(reference.getId()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamOffset)) {
            return false;
        }
        StreamOffset other = (StreamOffset)o;
        K this$key = this.getKey();
        K other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        ReadOffset this$offset = this.getOffset();
        ReadOffset other$offset = other.getOffset();
        return !(this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        K $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        ReadOffset $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        return result;
    }

    public String toString() {
        return "StreamOffset(key=" + this.getKey() + ", offset=" + this.getOffset() + ")";
    }

    public K getKey() {
        return this.key;
    }

    public ReadOffset getOffset() {
        return this.offset;
    }
}

