/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.StreamMessage;
import io.lettuce.core.XReadArgs;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.connection.convert.ListConverter;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;

class StreamConverters {
    StreamConverters() {
    }

    static XReadArgs toReadArgs(StreamReadOptions readOptions) {
        return StreamReadOptionsToXReadArgsConverter.INSTANCE.convert(readOptions);
    }

    public static Converter<StreamMessage<byte[], byte[]>, ByteRecord> byteRecordConverter() {
        return it -> StreamRecords.newRecord().in(it.getStream()).withId(it.getId()).ofBytes(it.getBody());
    }

    public static Converter<List<StreamMessage<byte[], byte[]>>, List<ByteRecord>> byteRecordListConverter() {
        return new ListConverter<StreamMessage<byte[], byte[]>, ByteRecord>(StreamConverters.byteRecordConverter());
    }

    static enum StreamReadOptionsToXReadArgsConverter implements Converter<StreamReadOptions, XReadArgs>
    {
        INSTANCE;


        @Override
        public XReadArgs convert(StreamReadOptions source) {
            XReadArgs args = new XReadArgs();
            if (source.isNoack()) {
                args.noack(true);
            }
            if (source.getBlock() != null) {
                args.block(source.getBlock());
            }
            if (source.getCount() != null) {
                args.count(source.getCount());
            }
            return args;
        }
    }
}

