/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.Range;
import io.lettuce.core.ScanStream;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.ZStoreArgs;
import java.nio.ByteBuffer;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveZSetCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.data.redis.connection.lettuce.RangeConverter;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveZSetCommands
implements ReactiveZSetCommands {
    private final LettuceReactiveRedisConnection connection;

    LettuceReactiveZSetCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, "Connection must not be null!");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Number>> zAdd(Publisher<ReactiveZSetCommands.ZAddCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notEmpty(command.getTuples(), "Tuples must not be empty or null!");
            ZAddArgs args = null;
            if (command.isIncr() || command.isUpsert() || command.isReturnTotalChanged()) {
                if (command.isIncr()) {
                    if (command.getTuples().size() > 1) {
                        throw new IllegalArgumentException("ZADD INCR must not contain more than one tuple!");
                    }
                    RedisZSetCommands.Tuple tuple2 = command.getTuples().iterator().next();
                    return cmd.zaddincr(command.getKey(), tuple2.getScore(), ByteBuffer.wrap(tuple2.getValue())).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Double>((ReactiveZSetCommands.ZAddCommand)command, (Double)value));
                }
                if (command.isReturnTotalChanged()) {
                    args = ZAddArgs.Builder.ch();
                }
                args = command.isUpsert() ? ZAddArgs.Builder.nx() : ZAddArgs.Builder.xx();
            }
            ScoredValue[] values = (ScoredValue[])command.getTuples().stream().map(tuple -> ScoredValue.fromNullable(tuple.getScore(), ByteBuffer.wrap(tuple.getValue()))).toArray(ScoredValue[]::new);
            Mono<Long> result = args == null ? cmd.zadd(command.getKey(), values) : cmd.zadd(command.getKey(), args, (ScoredValue<V>[])values);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Long>((ReactiveZSetCommands.ZAddCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemCommand, Long>> zRem(Publisher<ReactiveZSetCommands.ZRemCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notEmpty(command.getValues(), "Values must not be null or empty!");
            return cmd.zrem(command.getKey(), command.getValues().stream().toArray(ByteBuffer[]::new)).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemCommand, Long>((ReactiveZSetCommands.ZRemCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZIncrByCommand, Double>> zIncrBy(Publisher<ReactiveZSetCommands.ZIncrByCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getValue(), "Member must not be null!");
            Assert.notNull((Object)command.getIncrement(), "Increment value must not be null!");
            return cmd.zincrby(command.getKey(), command.getIncrement().doubleValue(), command.getValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZIncrByCommand, Double>((ReactiveZSetCommands.ZIncrByCommand)command, (Double)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRankCommand, Long>> zRank(Publisher<ReactiveZSetCommands.ZRankCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getValue(), "Value must not be null!");
            Mono<Long> result = ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? cmd.zrank(command.getKey(), command.getValue()) : cmd.zrevrank(command.getKey(), command.getValue());
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRankCommand, Long>((ReactiveZSetCommands.ZRankCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeCommand, Flux<RedisZSetCommands.Tuple>>> zRange(Publisher<ReactiveZSetCommands.ZRangeCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getRange(), "Range must not be null!");
            long start = LettuceConverters.getLowerBoundIndex(command.getRange());
            long stop = LettuceConverters.getUpperBoundIndex(command.getRange());
            Flux<RedisZSetCommands.Tuple> result = ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? (command.isWithScores() ? cmd.zrangeWithScores(command.getKey(), start, stop).map(sc -> new DefaultTuple(LettuceReactiveZSetCommands.getBytes(sc), sc.getScore())) : cmd.zrange(command.getKey(), start, stop).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN))) : (command.isWithScores() ? cmd.zrevrangeWithScores(command.getKey(), start, stop).map(sc -> new DefaultTuple(LettuceReactiveZSetCommands.getBytes(sc), sc.getScore())) : cmd.zrevrange(command.getKey(), start, stop).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN)));
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeCommand, Flux<RedisZSetCommands.Tuple>>((ReactiveZSetCommands.ZRangeCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByScoreCommand, Flux<RedisZSetCommands.Tuple>>> zRangeByScore(Publisher<ReactiveZSetCommands.ZRangeByScoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Flux<RedisZSetCommands.Tuple> result;
            boolean isLimited;
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getRange(), "Range must not be null!");
            boolean bl = isLimited = command.getLimit().isPresent() && !command.getLimit().get().isUnlimited();
            if (ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC)) {
                Range range = RangeConverter.toRange(command.getRange());
                result = command.isWithScores() ? (!isLimited ? cmd.zrangebyscoreWithScores(command.getKey(), range).map(sc -> new DefaultTuple(ByteUtils.getBytes((ByteBuffer)sc.getValue()), sc.getScore())) : cmd.zrangebyscoreWithScores(command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(sc -> new DefaultTuple(ByteUtils.getBytes((ByteBuffer)sc.getValue()), sc.getScore()))) : (!isLimited ? cmd.zrangebyscore(command.getKey(), range).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN)) : cmd.zrangebyscore(command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN)));
            } else {
                Range range = RangeConverter.toRange(command.getRange());
                result = command.isWithScores() ? (!isLimited ? cmd.zrevrangebyscoreWithScores(command.getKey(), range).map(sc -> new DefaultTuple(ByteUtils.getBytes((ByteBuffer)sc.getValue()), sc.getScore())) : cmd.zrevrangebyscoreWithScores(command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(sc -> new DefaultTuple(ByteUtils.getBytes((ByteBuffer)sc.getValue()), sc.getScore()))) : (!isLimited ? cmd.zrevrangebyscore(command.getKey(), range).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN)) : cmd.zrevrangebyscore(command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN)));
            }
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByScoreCommand, Flux<RedisZSetCommands.Tuple>>((ReactiveZSetCommands.ZRangeByScoreCommand)command, Flux.from(result)));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<RedisZSetCommands.Tuple>>> zScan(Publisher<ReactiveRedisConnection.KeyScanCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getOptions(), "ScanOptions must not be null!");
            Flux<RedisZSetCommands.Tuple> result = ScanStream.zscan(cmd, command.getKey(), LettuceConverters.toScanArgs(command.getOptions())).map(it -> new DefaultTuple(ByteUtils.getBytes((ByteBuffer)it.getValue()), it.getScore()));
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyScanCommand, Flux<RedisZSetCommands.Tuple>>((ReactiveRedisConnection.KeyScanCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZCountCommand, Long>> zCount(Publisher<ReactiveZSetCommands.ZCountCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getRange(), "Range must not be null!");
            Range range = RangeConverter.toRange(command.getRange());
            Mono<Long> result = cmd.zcount(command.getKey(), range);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZCountCommand, Long>((ReactiveZSetCommands.ZCountCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> zCard(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            return cmd.zcard(command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZScoreCommand, Double>> zScore(Publisher<ReactiveZSetCommands.ZScoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getValue(), "Value must not be null!");
            return cmd.zscore(command.getKey(), command.getValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZScoreCommand, Double>((ReactiveZSetCommands.ZScoreCommand)command, (Double)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByRankCommand, Long>> zRemRangeByRank(Publisher<ReactiveZSetCommands.ZRemRangeByRankCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getRange(), "Range must not be null!");
            Mono<Long> result = cmd.zremrangebyrank(command.getKey(), LettuceConverters.getLowerBoundIndex(command.getRange()), LettuceConverters.getUpperBoundIndex(command.getRange()));
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByRankCommand, Long>((ReactiveZSetCommands.ZRemRangeByRankCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByScoreCommand, Long>> zRemRangeByScore(Publisher<ReactiveZSetCommands.ZRemRangeByScoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getRange(), "Range must not be null!");
            Range range = RangeConverter.toRange(command.getRange());
            Mono<Long> result = cmd.zremrangebyscore(command.getKey(), range);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByScoreCommand, Long>((ReactiveZSetCommands.ZRemRangeByScoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZUnionStoreCommand, Long>> zUnionStore(Publisher<ReactiveZSetCommands.ZUnionStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Destination key must not be null!");
            Assert.notEmpty(command.getSourceKeys(), "Source keys must not be null or empty!");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = LettuceReactiveZSetCommands.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            ByteBuffer[] sourceKeys = (ByteBuffer[])command.getSourceKeys().stream().toArray(ByteBuffer[]::new);
            Mono<Long> result = args != null ? cmd.zunionstore(command.getKey(), args, (K[])sourceKeys) : cmd.zunionstore(command.getKey(), sourceKeys);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZUnionStoreCommand, Long>((ReactiveZSetCommands.ZUnionStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZInterStoreCommand, Long>> zInterStore(Publisher<ReactiveZSetCommands.ZInterStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Destination key must not be null!");
            Assert.notEmpty(command.getSourceKeys(), "Source keys must not be null or empty!");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = LettuceReactiveZSetCommands.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            ByteBuffer[] sourceKeys = (ByteBuffer[])command.getSourceKeys().stream().toArray(ByteBuffer[]::new);
            Mono<Long> result = args != null ? cmd.zinterstore(command.getKey(), args, (K[])sourceKeys) : cmd.zinterstore(command.getKey(), sourceKeys);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZInterStoreCommand, Long>((ReactiveZSetCommands.ZInterStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByLexCommand, Flux<ByteBuffer>>> zRangeByLex(Publisher<ReactiveZSetCommands.ZRangeByLexCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Destination key must not be null!");
            Flux result = !command.getLimit().isUnlimited() ? (ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? cmd.zrangebylex(command.getKey(), RangeConverter.toRange(command.getRange()), LettuceConverters.toLimit(command.getLimit())) : cmd.zrevrangebylex(command.getKey(), RangeConverter.toRange(command.getRange()), LettuceConverters.toLimit(command.getLimit()))) : (ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? cmd.zrangebylex(command.getKey(), RangeConverter.toRange(command.getRange())) : cmd.zrevrangebylex(command.getKey(), RangeConverter.toRange(command.getRange())));
            return Mono.just(new ReactiveRedisConnection.CommandResponse((ReactiveZSetCommands.ZRangeByLexCommand)command, result));
        }));
    }

    private static ZStoreArgs zStoreArgs(@Nullable RedisZSetCommands.Aggregate aggregate, @Nullable List<Double> weights) {
        ZStoreArgs args = new ZStoreArgs();
        if (aggregate != null) {
            switch (aggregate) {
                case MIN: {
                    args.min();
                    break;
                }
                case MAX: {
                    args.max();
                    break;
                }
                default: {
                    args.sum();
                }
            }
        }
        if (weights != null) {
            args.weights(weights.stream().mapToDouble(it -> it).toArray());
        }
        return args;
    }

    private static byte[] getBytes(ScoredValue<ByteBuffer> scoredValue) {
        return scoredValue.optional().map(ByteUtils::getBytes).orElse(new byte[0]);
    }

    protected LettuceReactiveRedisConnection getConnection() {
        return this.connection;
    }
}

