/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.api.reactive.RedisServerReactiveCommands;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Properties;
import org.springframework.data.redis.connection.ReactiveServerCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveServerCommands
implements ReactiveServerCommands {
    private final LettuceReactiveRedisConnection connection;

    LettuceReactiveServerCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, "Connection must not be null!");
        this.connection = connection;
    }

    @Override
    public Mono<String> bgReWriteAof() {
        return this.connection.execute(RedisServerReactiveCommands::bgrewriteaof).next();
    }

    @Override
    public Mono<String> bgSave() {
        return this.connection.execute(RedisServerReactiveCommands::bgsave).next();
    }

    @Override
    public Mono<Long> lastSave() {
        return this.connection.execute(RedisServerReactiveCommands::lastsave).next().map(Date::getTime);
    }

    @Override
    public Mono<String> save() {
        return this.connection.execute(RedisServerReactiveCommands::save).next();
    }

    @Override
    public Mono<Long> dbSize() {
        return this.connection.execute(RedisServerReactiveCommands::dbsize).next();
    }

    @Override
    public Mono<String> flushDb() {
        return this.connection.execute(RedisServerReactiveCommands::flushdb).next();
    }

    @Override
    public Mono<String> flushAll() {
        return this.connection.execute(RedisServerReactiveCommands::flushall).next();
    }

    @Override
    public Mono<Properties> info() {
        return this.connection.execute(RedisServerReactiveCommands::info).map(Converters::toProperties).next();
    }

    @Override
    public Mono<Properties> info(String section) {
        Assert.hasText(section, "Section must not be null or empty!");
        return this.connection.execute(c -> c.info(section)).map(Converters::toProperties).next();
    }

    @Override
    public Mono<Properties> getConfig(String pattern) {
        Assert.hasText(pattern, "Pattern must not be null or empty!");
        return this.connection.execute(c -> c.configGet(pattern)).map(Converters::toProperties).next();
    }

    @Override
    public Mono<String> setConfig(String param, String value) {
        Assert.hasText(param, "Parameter must not be null or empty!");
        Assert.hasText(value, "Value must not be null or empty!");
        return this.connection.execute(c -> c.configSet(param, value)).next();
    }

    @Override
    public Mono<String> resetConfigStats() {
        return this.connection.execute(RedisServerReactiveCommands::configResetstat).next();
    }

    @Override
    public Mono<Long> time() {
        return this.connection.execute(RedisServerReactiveCommands::time).map(ByteUtils::getBytes).collectList().map(LettuceConverters.toTimeConverter()::convert);
    }

    @Override
    public Mono<String> killClient(String host, int port) {
        Assert.notNull((Object)host, "Host must not be null or empty!");
        return this.connection.execute(c -> c.clientKill(String.format("%s:%s", host, port))).next();
    }

    @Override
    public Mono<String> setClientName(String name) {
        Assert.hasText(name, "Name must not be null or empty!");
        return this.connection.execute(c -> c.clientSetname(ByteBuffer.wrap(LettuceConverters.toBytes(name)))).next();
    }

    @Override
    public Mono<String> getClientName() {
        return this.connection.execute(RedisServerReactiveCommands::clientGetname).map(ByteUtils::getBytes).map(LettuceConverters::toString).next();
    }

    @Override
    public Flux<RedisClientInfo> getClientList() {
        return this.connection.execute(RedisServerReactiveCommands::clientList).concatMapIterable(s -> LettuceConverters.stringToRedisClientListConverter().convert((String)s));
    }
}

