/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ScanStream;
import io.lettuce.core.api.reactive.RedisKeyReactiveCommands;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ReactiveKeyCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveKeyCommands
implements ReactiveKeyCommands {
    private final LettuceReactiveRedisConnection connection;

    LettuceReactiveKeyCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, "Connection must not be null!");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>> exists(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            return cmd.exists(command.getKey()).map(LettuceConverters.longToBooleanConverter()::convert).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, DataType>> type(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            return cmd.type(command.getKey()).map(Converters::toDataType).map(respValue -> new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, DataType>((ReactiveRedisConnection.KeyCommand)command, (DataType)((Object)((Object)((Object)respValue)))));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<Collection<ByteBuffer>, Long>> touch(Publisher<Collection<ByteBuffer>> keysCollection) {
        return this.connection.execute(cmd -> Flux.from(keysCollection).concatMap(keys -> {
            Assert.notEmpty(keys, "Keys must not be null!");
            return cmd.touch(keys.toArray(new ByteBuffer[keys.size()])).map(value -> new ReactiveRedisConnection.NumericResponse<Collection, Long>((Collection)keys, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ByteBuffer, ByteBuffer>> keys(Publisher<ByteBuffer> patterns) {
        return this.connection.execute(cmd -> Flux.from(patterns).concatMap(pattern -> {
            Assert.notNull(pattern, "Pattern must not be null!");
            return cmd.keys(pattern).collectList().map(value -> new ReactiveRedisConnection.MultiValueResponse((ByteBuffer)pattern, value));
        }));
    }

    @Override
    public Flux<ByteBuffer> scan(ScanOptions options) {
        Assert.notNull((Object)options, "ScanOptions must not be null!");
        return this.connection.execute(cmd -> ScanStream.scan(cmd, LettuceConverters.toScanArgs(options)));
    }

    @Override
    public Mono<ByteBuffer> randomKey() {
        return this.connection.execute(RedisKeyReactiveCommands::randomkey).next();
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>> rename(Publisher<ReactiveKeyCommands.RenameCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getNewName(), "New name must not be null!");
            return cmd.rename(command.getKey(), command.getNewName()).map(Converters::stringToBoolean).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>((ReactiveKeyCommands.RenameCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>> renameNX(Publisher<ReactiveKeyCommands.RenameCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getNewName(), "New name must not be null!");
            return cmd.renamenx(command.getKey(), command.getNewName()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>((ReactiveKeyCommands.RenameCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> del(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            return cmd.del(command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<List<ByteBuffer>, Long>> mDel(Publisher<List<ByteBuffer>> keysCollection) {
        return this.connection.execute(cmd -> Flux.from(keysCollection).concatMap(keys -> {
            Assert.notEmpty(keys, "Keys must not be null!");
            return cmd.del(keys.toArray(new ByteBuffer[keys.size()])).map(value -> new ReactiveRedisConnection.NumericResponse<List, Long>((List)keys, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> unlink(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            return cmd.unlink(command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<List<ByteBuffer>, Long>> mUnlink(Publisher<List<ByteBuffer>> keysCollection) {
        return this.connection.execute(cmd -> Flux.from(keysCollection).concatMap(keys -> {
            Assert.notEmpty(keys, "Keys must not be null!");
            return cmd.unlink(keys.toArray(new ByteBuffer[keys.size()])).map(value -> new ReactiveRedisConnection.NumericResponse<List, Long>((List)keys, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireCommand>> expire(Publisher<ReactiveKeyCommands.ExpireCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getTimeout(), "Timeout must not be null!");
            return cmd.expire(command.getKey(), command.getTimeout().getSeconds()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireCommand>((ReactiveKeyCommands.ExpireCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireCommand>> pExpire(Publisher<ReactiveKeyCommands.ExpireCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getTimeout(), "Timeout must not be null!");
            return cmd.pexpire(command.getKey(), command.getTimeout().toMillis()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireCommand>((ReactiveKeyCommands.ExpireCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireAtCommand>> expireAt(Publisher<ReactiveKeyCommands.ExpireAtCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getExpireAt(), "Expire at must not be null!");
            return cmd.expireat(command.getKey(), command.getExpireAt().getEpochSecond()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireAtCommand>((ReactiveKeyCommands.ExpireAtCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireAtCommand>> pExpireAt(Publisher<ReactiveKeyCommands.ExpireAtCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getExpireAt(), "Expire at must not be null!");
            return cmd.pexpireat(command.getKey(), command.getExpireAt().toEpochMilli()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireAtCommand>((ReactiveKeyCommands.ExpireAtCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>> persist(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            return cmd.persist(command.getKey()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> ttl(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            return cmd.ttl(command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> pTtl(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            return cmd.pttl(command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.MoveCommand>> move(Publisher<ReactiveKeyCommands.MoveCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getDatabase(), "Database must not be null!");
            return cmd.move(command.getKey(), command.getDatabase()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.MoveCommand>((ReactiveKeyCommands.MoveCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Mono<ValueEncoding> encodingOf(ByteBuffer key) {
        return this.connection.execute(cmd -> cmd.objectEncoding(key).map(ValueEncoding::of).defaultIfEmpty(ValueEncoding.RedisValueEncoding.VACANT)).next();
    }

    @Override
    public Mono<Duration> idletime(ByteBuffer key) {
        return this.connection.execute(cmd -> cmd.objectIdletime(key).map(Duration::ofSeconds)).next();
    }

    @Override
    public Mono<Long> refcount(ByteBuffer key) {
        return this.connection.execute(cmd -> cmd.objectRefcount(key)).next();
    }
}

