/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.List;
import lombok.NonNull;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceResult;
import org.springframework.util.Assert;

class LettuceListCommands
implements RedisListCommands {
    @NonNull
    private final LettuceConnection connection;

    @Override
    public Long rPush(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().rpush(key, (V[])values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().rpush(key, (V[])values)));
                return null;
            }
            return this.getConnection().rpush(key, (V[])values);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lPush(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)values, "Values must not be null!");
        Assert.noNullElements((Object[])values, "Values must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().lpush(key, (V[])values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().lpush(key, (V[])values)));
                return null;
            }
            return this.getConnection().lpush(key, (V[])values);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().rpushx(key, (V[])new byte[][]{value})));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().rpushx(key, (V[])new byte[][]{value})));
                return null;
            }
            return this.getConnection().rpushx(key, (V[])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().lpushx(key, (V[])new byte[][]{value})));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().lpushx(key, (V[])new byte[][]{value})));
                return null;
            }
            return this.getConnection().lpushx(key, (V[])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lLen(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().llen(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().llen(key)));
                return null;
            }
            return this.getConnection().llen(key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().lrange(key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().lrange(key, start, end)));
                return null;
            }
            return this.getConnection().lrange(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult(this.getAsyncConnection().ltrim(key, start, end)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceStatusResult(this.getAsyncConnection().ltrim(key, start, end)));
                return;
            }
            this.getConnection().ltrim(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().lindex(key, index)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().lindex(key, index)));
                return null;
            }
            return (byte[])this.getConnection().lindex(key, index);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().linsert(key, LettuceConverters.toBoolean(where), pivot, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().linsert(key, LettuceConverters.toBoolean(where), pivot, value)));
                return null;
            }
            return this.getConnection().linsert(key, LettuceConverters.toBoolean(where), pivot, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult(this.getAsyncConnection().lset(key, index, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceStatusResult(this.getAsyncConnection().lset(key, index, value)));
                return;
            }
            this.getConnection().lset(key, index, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().lrem(key, count, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().lrem(key, count, value)));
                return null;
            }
            return this.getConnection().lrem(key, count, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] lPop(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().lpop(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().lpop(key)));
                return null;
            }
            return (byte[])this.getConnection().lpop(key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] rPop(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().rpop(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().rpop(key)));
                return null;
            }
            return (byte[])this.getConnection().rpop(key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, "Key must not be null!");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.connection.getAsyncDedicatedConnection().blpop(timeout, (K[])keys), LettuceConverters.keyValueToBytesList()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.connection.getAsyncDedicatedConnection().blpop(timeout, (K[])keys), LettuceConverters.keyValueToBytesList()));
                return null;
            }
            return LettuceConverters.toBytesList(this.connection.getDedicatedConnection().blpop(timeout, (K[])keys));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, "Key must not be null!");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.connection.getAsyncDedicatedConnection().brpop(timeout, (K[])keys), LettuceConverters.keyValueToBytesList()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.connection.getAsyncDedicatedConnection().brpop(timeout, (K[])keys), LettuceConverters.keyValueToBytesList()));
                return null;
            }
            return LettuceConverters.toBytesList(this.connection.getDedicatedConnection().brpop(timeout, (K[])keys));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        Assert.notNull((Object)srcKey, "Source key must not be null!");
        Assert.notNull((Object)dstKey, "Destination key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().rpoplpush(srcKey, dstKey)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().rpoplpush(srcKey, dstKey)));
                return null;
            }
            return (byte[])this.getConnection().rpoplpush(srcKey, dstKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        Assert.notNull((Object)srcKey, "Source key must not be null!");
        Assert.notNull((Object)dstKey, "Destination key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.connection.getAsyncDedicatedConnection().brpoplpush(timeout, srcKey, dstKey)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.connection.getAsyncDedicatedConnection().brpoplpush(timeout, srcKey, dstKey)));
                return null;
            }
            return (byte[])this.connection.getDedicatedConnection().brpoplpush(timeout, srcKey, dstKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceResult result) {
        this.connection.transaction(result);
    }

    private RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }

    public LettuceListCommands(@NonNull LettuceConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        this.connection = connection;
    }
}

