/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.util.Assert;

public class RedisSocketConfiguration
implements RedisConfiguration,
RedisConfiguration.DomainSocketConfiguration {
    private static final String DEFAULT_SOCKET = "/tmp/redis.sock";
    private String socket = "/tmp/redis.sock";
    private int database;
    private RedisPassword password = RedisPassword.none();

    public RedisSocketConfiguration() {
    }

    public RedisSocketConfiguration(String socket) {
        Assert.hasText(socket, "Socket path must not be null nor empty!");
        this.socket = socket;
    }

    @Override
    public String getSocket() {
        return this.socket;
    }

    @Override
    public void setSocket(String socket) {
        Assert.hasText(socket, "Socket must not be null nor empty!");
        this.socket = socket;
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(int index) {
        Assert.isTrue(index >= 0, () -> String.format("Invalid DB index '%s' (a positive index required)", index));
        this.database = index;
    }

    @Override
    public RedisPassword getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(RedisPassword password) {
        Assert.notNull((Object)password, "RedisPassword must not be null!");
        this.password = password;
    }
}

