/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface RedisGeoCommands {
    @Nullable
    public Long geoAdd(byte[] var1, Point var2, byte[] var3);

    @Nullable
    default public Long geoAdd(byte[] key, GeoLocation<byte[]> location) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(location, "Location must not be null!");
        return this.geoAdd(key, location.getPoint(), location.getName());
    }

    @Nullable
    public Long geoAdd(byte[] var1, Map<byte[], Point> var2);

    @Nullable
    public Long geoAdd(byte[] var1, Iterable<GeoLocation<byte[]>> var2);

    @Nullable
    public Distance geoDist(byte[] var1, byte[] var2, byte[] var3);

    @Nullable
    public Distance geoDist(byte[] var1, byte[] var2, byte[] var3, Metric var4);

    @Nullable
    public List<String> geoHash(byte[] var1, byte[] ... var2);

    @Nullable
    public List<Point> geoPos(byte[] var1, byte[] ... var2);

    @Nullable
    public GeoResults<GeoLocation<byte[]>> geoRadius(byte[] var1, Circle var2);

    @Nullable
    public GeoResults<GeoLocation<byte[]>> geoRadius(byte[] var1, Circle var2, GeoRadiusCommandArgs var3);

    @Nullable
    default public GeoResults<GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, double radius) {
        return this.geoRadiusByMember(key, member, new Distance(radius, DistanceUnit.METERS));
    }

    @Nullable
    public GeoResults<GeoLocation<byte[]>> geoRadiusByMember(byte[] var1, byte[] var2, Distance var3);

    @Nullable
    public GeoResults<GeoLocation<byte[]>> geoRadiusByMember(byte[] var1, byte[] var2, Distance var3, GeoRadiusCommandArgs var4);

    @Nullable
    public Long geoRemove(byte[] var1, byte[] ... var2);

    public static enum DistanceUnit implements Metric
    {
        METERS(6378137.0, "m"),
        KILOMETERS(6378.137, "km"),
        MILES(3963.191, "mi"),
        FEET(2.0925646325E7, "ft");

        private final double multiplier;
        private final String abbreviation;

        private DistanceUnit(double multiplier, String abbreviation) {
            this.multiplier = multiplier;
            this.abbreviation = abbreviation;
        }

        @Override
        public double getMultiplier() {
            return this.multiplier;
        }

        @Override
        public String getAbbreviation() {
            return this.abbreviation;
        }
    }

    public static class GeoLocation<T> {
        private final T name;
        private final Point point;

        public T getName() {
            return this.name;
        }

        public Point getPoint() {
            return this.point;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeoLocation)) {
                return false;
            }
            GeoLocation other = (GeoLocation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$name = this.getName();
            T other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Point this$point = this.getPoint();
            Point other$point = other.getPoint();
            return !(this$point == null ? other$point != null : !((Object)this$point).equals(other$point));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GeoLocation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Point $point = this.getPoint();
            result = result * 59 + ($point == null ? 43 : ((Object)$point).hashCode());
            return result;
        }

        public String toString() {
            return "RedisGeoCommands.GeoLocation(name=" + this.getName() + ", point=" + this.getPoint() + ")";
        }

        public GeoLocation(T name, Point point) {
            this.name = name;
            this.point = point;
        }
    }

    public static class GeoRadiusCommandArgs
    implements Cloneable {
        Set<Flag> flags = new LinkedHashSet<Flag>(2, 1.0f);
        @Nullable
        Long limit;
        @Nullable
        Sort.Direction sortDirection;

        private GeoRadiusCommandArgs() {
        }

        public static GeoRadiusCommandArgs newGeoRadiusArgs() {
            return new GeoRadiusCommandArgs();
        }

        public GeoRadiusCommandArgs includeCoordinates() {
            this.flags.add(Flag.WITHCOORD);
            return this;
        }

        public GeoRadiusCommandArgs includeDistance() {
            this.flags.add(Flag.WITHDIST);
            return this;
        }

        public GeoRadiusCommandArgs sortAscending() {
            this.sortDirection = Sort.Direction.ASC;
            return this;
        }

        public GeoRadiusCommandArgs sortDescending() {
            this.sortDirection = Sort.Direction.DESC;
            return this;
        }

        public GeoRadiusCommandArgs limit(long count) {
            Assert.isTrue(count > 0L, "Count has to positive value.");
            this.limit = count;
            return this;
        }

        public Set<Flag> getFlags() {
            return this.flags;
        }

        @Nullable
        public Long getLimit() {
            return this.limit;
        }

        @Nullable
        public Sort.Direction getSortDirection() {
            return this.sortDirection;
        }

        public boolean hasFlags() {
            return !this.flags.isEmpty();
        }

        public boolean hasSortDirection() {
            return this.sortDirection != null;
        }

        public boolean hasLimit() {
            return this.limit != null;
        }

        protected GeoRadiusCommandArgs clone() {
            GeoRadiusCommandArgs tmp = new GeoRadiusCommandArgs();
            tmp.flags = this.flags != null ? new LinkedHashSet<Flag>(this.flags) : new LinkedHashSet(2);
            tmp.limit = this.limit;
            tmp.sortDirection = this.sortDirection;
            return tmp;
        }

        public static enum Flag {
            WITHCOORD,
            WITHDIST;

        }
    }
}

