/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ConvertingPropertyAccessor<T>
implements PersistentPropertyAccessor<T> {
    private final PersistentPropertyAccessor<T> accessor;
    private final ConversionService conversionService;

    public ConvertingPropertyAccessor(PersistentPropertyAccessor<T> accessor, ConversionService conversionService) {
        Assert.notNull(accessor, "PersistentPropertyAccessor must not be null!");
        Assert.notNull((Object)conversionService, "ConversionService must not be null!");
        this.accessor = accessor;
        this.conversionService = conversionService;
    }

    @Override
    public void setProperty(PersistentProperty<?> property, @Nullable Object value) {
        this.accessor.setProperty(property, this.convertIfNecessary(value, property.getType()));
    }

    @Override
    public void setProperty(PersistentPropertyPath<? extends PersistentProperty<?>> path, @Nullable Object value) {
        Object converted = this.convertIfNecessary(value, path.getRequiredLeafProperty().getType());
        PersistentPropertyAccessor.super.setProperty(path, converted);
    }

    @Override
    @Nullable
    public Object getProperty(PersistentProperty<?> property) {
        return this.accessor.getProperty(property);
    }

    @Nullable
    public <S> S getProperty(PersistentProperty<?> property, Class<S> targetType) {
        Assert.notNull(property, "PersistentProperty must not be null!");
        Assert.notNull(targetType, "Target type must not be null!");
        return this.convertIfNecessary(this.getProperty(property), targetType);
    }

    @Override
    public T getBean() {
        return this.accessor.getBean();
    }

    @Nullable
    private <S> S convertIfNecessary(@Nullable Object source, Class<S> type) {
        return (S)(source == null ? null : (type.isAssignableFrom(source.getClass()) ? source : this.conversionService.convert(source, type)));
    }
}

