/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ConnectionBuilder;
import io.lettuce.core.ConnectionEventTrigger;
import io.lettuce.core.ConnectionEvents;
import io.lettuce.core.PlainChannelInitializer;
import io.lettuce.core.RedisChannelInitializer;
import io.lettuce.core.RedisChannelInitializerImpl;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SslOptions;
import io.lettuce.core.event.connection.ConnectedEvent;
import io.lettuce.core.event.connection.ConnectionActivatedEvent;
import io.lettuce.core.event.connection.DisconnectedEvent;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.AsyncCommand;
import io.lettuce.core.resource.ClientResources;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;

public class SslConnectionBuilder
extends ConnectionBuilder {
    private RedisURI redisURI;

    public SslConnectionBuilder ssl(RedisURI redisURI) {
        this.redisURI = redisURI;
        return this;
    }

    public static SslConnectionBuilder sslConnectionBuilder() {
        return new SslConnectionBuilder();
    }

    @Override
    protected List<ChannelHandler> buildHandlers() {
        LettuceAssert.assertState(this.redisURI != null, "RedisURI must not be null");
        LettuceAssert.assertState(this.redisURI.isSsl(), "RedisURI is not configured for SSL (ssl is false)");
        return super.buildHandlers();
    }

    @Override
    public RedisChannelInitializer build() {
        return new SslChannelInitializer(this.getPingCommandSupplier(), this::buildHandlers, this.redisURI, this.clientResources(), this.getTimeout(), this.clientOptions().getSslOptions());
    }

    static class SslChannelInitializer
    extends ChannelInitializer<Channel>
    implements RedisChannelInitializer {
        private final Supplier<AsyncCommand<?, ?, ?>> pingCommandSupplier;
        private final Supplier<List<ChannelHandler>> handlers;
        private final RedisURI redisURI;
        private final ClientResources clientResources;
        private final Duration timeout;
        private final SslOptions sslOptions;
        private volatile CompletableFuture<Boolean> initializedFuture = new CompletableFuture();

        public SslChannelInitializer(Supplier<AsyncCommand<?, ?, ?>> pingCommandSupplier, Supplier<List<ChannelHandler>> handlers, RedisURI redisURI, ClientResources clientResources, Duration timeout, SslOptions sslOptions) {
            this.pingCommandSupplier = pingCommandSupplier;
            this.handlers = handlers;
            this.redisURI = redisURI;
            this.clientResources = clientResources;
            this.timeout = timeout;
            this.sslOptions = sslOptions;
        }

        @Override
        protected void initChannel(Channel channel) throws Exception {
            Throwable throwable;
            InputStream is;
            SSLParameters sslParams = new SSLParameters();
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(this.sslOptions.getSslProvider());
            if (this.redisURI.isVerifyPeer()) {
                sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            } else {
                sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            }
            if (this.sslOptions.getKeystore() != null) {
                is = this.sslOptions.getKeystore().openStream();
                throwable = null;
                try {
                    sslContextBuilder.keyManager(SslChannelInitializer.createKeyManagerFactory(is, this.sslOptions.getKeystorePassword().length == 0 ? null : this.sslOptions.getKeystorePassword()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            if (this.sslOptions.getTruststore() != null) {
                is = this.sslOptions.getTruststore().openStream();
                throwable = null;
                try {
                    sslContextBuilder.trustManager(SslChannelInitializer.createTrustManagerFactory(is, this.sslOptions.getTruststorePassword().length == 0 ? null : this.sslOptions.getTruststorePassword()));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            SslContext sslContext = sslContextBuilder.build();
            SSLEngine sslEngine = sslContext.newEngine(channel.alloc(), this.redisURI.getHost(), this.redisURI.getPort());
            sslEngine.setSSLParameters(sslParams);
            if (channel.pipeline().get("first") == null) {
                channel.pipeline().addFirst("first", (ChannelHandler)new ChannelDuplexHandler(){

                    @Override
                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        clientResources.eventBus().publish(new ConnectedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
                        super.channelActive(ctx);
                    }

                    @Override
                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        clientResources.eventBus().publish(new DisconnectedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
                        super.channelInactive(ctx);
                    }
                });
            }
            SslHandler sslHandler = new SslHandler(sslEngine, this.redisURI.isStartTls());
            channel.pipeline().addLast(sslHandler);
            if (channel.pipeline().get("channelActivator") == null) {
                channel.pipeline().addLast("channelActivator", (ChannelHandler)new RedisChannelInitializerImpl(){
                    private AsyncCommand<?, ?, ?> pingCommand;

                    @Override
                    public CompletableFuture<Boolean> channelInitialized() {
                        return initializedFuture;
                    }

                    @Override
                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        if (!initializedFuture.isDone()) {
                            initializedFuture.completeExceptionally(new RedisConnectionException("Connection closed prematurely"));
                        }
                        initializedFuture = new CompletableFuture();
                        this.pingCommand = null;
                        super.channelInactive(ctx);
                    }

                    @Override
                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        if (initializedFuture.isDone()) {
                            super.channelActive(ctx);
                        }
                    }

                    @Override
                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt instanceof SslHandshakeCompletionEvent && !initializedFuture.isDone()) {
                            SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
                            if (event.isSuccess()) {
                                if (pingCommandSupplier != PlainChannelInitializer.NO_PING) {
                                    this.pingCommand = (AsyncCommand)pingCommandSupplier.get();
                                    PlainChannelInitializer.pingBeforeActivate(this.pingCommand, initializedFuture, ctx, clientResources, timeout);
                                } else {
                                    ctx.fireChannelActive();
                                }
                            } else {
                                initializedFuture.completeExceptionally(event.cause());
                            }
                        }
                        if (evt instanceof ConnectionEvents.Activated && !initializedFuture.isDone()) {
                            initializedFuture.complete(true);
                            clientResources.eventBus().publish(new ConnectionActivatedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
                        }
                        super.userEventTriggered(ctx, evt);
                    }

                    @Override
                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause instanceof SSLHandshakeException || cause.getCause() instanceof SSLException) {
                            initializedFuture.completeExceptionally(cause);
                        }
                        super.exceptionCaught(ctx, cause);
                    }
                });
            }
            for (ChannelHandler handler : this.handlers.get()) {
                channel.pipeline().addLast(handler);
            }
            this.clientResources.nettyCustomizer().afterChannelInitialized(channel);
        }

        @Override
        public CompletableFuture<Boolean> channelInitialized() {
            return this.initializedFuture;
        }

        private static KeyManagerFactory createKeyManagerFactory(InputStream inputStream, char[] storePassword) throws GeneralSecurityException, IOException {
            KeyStore keyStore = SslChannelInitializer.getKeyStore(inputStream, storePassword);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, storePassword == null ? new char[]{} : storePassword);
            return keyManagerFactory;
        }

        private static KeyStore getKeyStore(InputStream inputStream, char[] storePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try {
                keyStore.load(inputStream, storePassword);
            }
            finally {
                inputStream.close();
            }
            return keyStore;
        }

        private static TrustManagerFactory createTrustManagerFactory(InputStream inputStream, char[] storePassword) throws GeneralSecurityException, IOException {
            KeyStore trustStore = SslChannelInitializer.getKeyStore(inputStream, storePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            return trustManagerFactory;
        }
    }
}

