/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.ConnectionBuilder;
import io.lettuce.core.ConnectionEvents;
import io.lettuce.core.ConnectionFuture;
import io.lettuce.core.ConnectionPoint;
import io.lettuce.core.DefaultConnectionFuture;
import io.lettuce.core.ExceptionFactory;
import io.lettuce.core.LettuceStrings;
import io.lettuce.core.RedisChannelHandler;
import io.lettuce.core.RedisChannelInitializer;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.RedisCommandInterruptedException;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisConnectionStateListener;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SocketOptions;
import io.lettuce.core.Transports;
import io.lettuce.core.internal.AsyncCloseable;
import io.lettuce.core.internal.Futures;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.ConnectionWatchdog;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.HashedWheelTimer;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.publisher.Mono;

public abstract class AbstractRedisClient {
    protected static final PooledByteBufAllocator BUF_ALLOCATOR = PooledByteBufAllocator.DEFAULT;
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisClient.class);
    protected final Map<Class<? extends EventLoopGroup>, EventLoopGroup> eventLoopGroups = new ConcurrentHashMap<Class<? extends EventLoopGroup>, EventLoopGroup>(2);
    protected final ConnectionEvents connectionEvents = new ConnectionEvents();
    protected final Set<Closeable> closeableResources = ConcurrentHashMap.newKeySet();
    protected final EventExecutorGroup genericWorkerPool;
    protected final HashedWheelTimer timer;
    protected final ChannelGroup channels;
    protected final ClientResources clientResources;
    protected volatile ClientOptions clientOptions = ClientOptions.builder().build();
    protected Duration timeout = RedisURI.DEFAULT_TIMEOUT_DURATION;
    private final boolean sharedResources;
    private final AtomicBoolean shutdown = new AtomicBoolean();

    protected AbstractRedisClient(ClientResources clientResources) {
        if (clientResources == null) {
            this.sharedResources = false;
            this.clientResources = DefaultClientResources.create();
        } else {
            this.sharedResources = true;
            this.clientResources = clientResources;
        }
        this.genericWorkerPool = this.clientResources.eventExecutorGroup();
        this.channels = new DefaultChannelGroup(this.genericWorkerPool.next());
        this.timer = (HashedWheelTimer)this.clientResources.timer();
    }

    public void setDefaultTimeout(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout duration must not be null");
        LettuceAssert.isTrue(!timeout.isNegative(), "Timeout duration must be greater or equal to zero");
        this.timeout = timeout;
    }

    @Deprecated
    public void setDefaultTimeout(long timeout, TimeUnit unit) {
        this.setDefaultTimeout(Duration.ofNanos(unit.toNanos(timeout)));
    }

    protected void connectionBuilder(Mono<SocketAddress> socketAddressSupplier, ConnectionBuilder connectionBuilder, RedisURI redisURI) {
        Bootstrap redisBootstrap = new Bootstrap();
        redisBootstrap.option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, 32768);
        redisBootstrap.option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, 8192);
        redisBootstrap.option(ChannelOption.ALLOCATOR, BUF_ALLOCATOR);
        SocketOptions socketOptions = this.getOptions().getSocketOptions();
        redisBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, Math.toIntExact(socketOptions.getConnectTimeout().toMillis()));
        if (LettuceStrings.isEmpty(redisURI.getSocket())) {
            redisBootstrap.option(ChannelOption.SO_KEEPALIVE, socketOptions.isKeepAlive());
            redisBootstrap.option(ChannelOption.TCP_NODELAY, socketOptions.isTcpNoDelay());
        }
        connectionBuilder.timeout(redisURI.getTimeout());
        connectionBuilder.password(redisURI.getPassword());
        connectionBuilder.bootstrap(redisBootstrap);
        connectionBuilder.channelGroup(this.channels).connectionEvents(this.connectionEvents).timer(this.timer);
        connectionBuilder.socketAddressSupplier(socketAddressSupplier);
    }

    protected void channelType(ConnectionBuilder connectionBuilder, ConnectionPoint connectionPoint) {
        LettuceAssert.notNull((Object)connectionPoint, "ConnectionPoint must not be null");
        connectionBuilder.bootstrap().group(this.getEventLoopGroup(connectionPoint));
        if (connectionPoint.getSocket() != null) {
            Transports.NativeTransports.assertAvailable();
            connectionBuilder.bootstrap().channel(Transports.NativeTransports.domainSocketChannelClass());
        } else {
            connectionBuilder.bootstrap().channel(Transports.socketChannelClass());
        }
    }

    private synchronized EventLoopGroup getEventLoopGroup(ConnectionPoint connectionPoint) {
        if (connectionPoint.getSocket() == null && !this.eventLoopGroups.containsKey(Transports.eventLoopGroupClass())) {
            this.eventLoopGroups.put(Transports.eventLoopGroupClass(), this.clientResources.eventLoopGroupProvider().allocate(Transports.eventLoopGroupClass()));
        }
        if (connectionPoint.getSocket() != null) {
            Transports.NativeTransports.assertAvailable();
            Class<? extends EventLoopGroup> eventLoopGroupClass = Transports.NativeTransports.eventLoopGroupClass();
            if (!this.eventLoopGroups.containsKey(Transports.NativeTransports.eventLoopGroupClass())) {
                this.eventLoopGroups.put(eventLoopGroupClass, this.clientResources.eventLoopGroupProvider().allocate(eventLoopGroupClass));
            }
        }
        if (connectionPoint.getSocket() == null) {
            return this.eventLoopGroups.get(Transports.eventLoopGroupClass());
        }
        if (connectionPoint.getSocket() != null) {
            Transports.NativeTransports.assertAvailable();
            return this.eventLoopGroups.get(Transports.NativeTransports.eventLoopGroupClass());
        }
        throw new IllegalStateException("This should not have happened in a binary decision. Please file a bug.");
    }

    protected <T> T getConnection(ConnectionFuture<T> connectionFuture) {
        try {
            return connectionFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RedisConnectionException.create(connectionFuture.getRemoteAddress(), (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                throw RedisConnectionException.create(connectionFuture.getRemoteAddress(), e.getCause());
            }
            throw RedisConnectionException.create(connectionFuture.getRemoteAddress(), (Throwable)e);
        }
    }

    protected <T> T getConnection(CompletableFuture<T> connectionFuture) {
        try {
            return connectionFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RedisConnectionException.create(e);
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                throw RedisConnectionException.create(e.getCause());
            }
            throw RedisConnectionException.create(e);
        }
    }

    protected <K, V, T extends RedisChannelHandler<K, V>> ConnectionFuture<T> initializeChannelAsync(ConnectionBuilder connectionBuilder) {
        Mono<SocketAddress> socketAddressSupplier = connectionBuilder.socketAddress();
        if (this.clientResources.eventExecutorGroup().isShuttingDown()) {
            throw new IllegalStateException("Cannot connect, Event executor group is terminated.");
        }
        CompletableFuture<SocketAddress> socketAddressFuture = new CompletableFuture<SocketAddress>();
        CompletableFuture channelReadyFuture = new CompletableFuture();
        socketAddressSupplier.doOnError(socketAddressFuture::completeExceptionally).doOnNext(socketAddressFuture::complete).subscribe(redisAddress -> {
            if (channelReadyFuture.isCancelled()) {
                return;
            }
            this.initializeChannelAsync0(connectionBuilder, channelReadyFuture, (SocketAddress)redisAddress);
        }, channelReadyFuture::completeExceptionally);
        return new DefaultConnectionFuture(socketAddressFuture, channelReadyFuture.thenApply(channel -> connectionBuilder.connection()));
    }

    private void initializeChannelAsync0(ConnectionBuilder connectionBuilder, CompletableFuture<Channel> channelReadyFuture, SocketAddress redisAddress) {
        logger.debug("Connecting to Redis at {}", (Object)redisAddress);
        Bootstrap redisBootstrap = connectionBuilder.bootstrap();
        RedisChannelInitializer initializer = connectionBuilder.build();
        redisBootstrap.handler(initializer);
        this.clientResources.nettyCustomizer().afterBootstrapInitialized(redisBootstrap);
        CompletableFuture<Boolean> initFuture = initializer.channelInitialized();
        ChannelFuture connectFuture = redisBootstrap.connect(redisAddress);
        channelReadyFuture.whenComplete((c, t) -> {
            if (t instanceof CancellationException) {
                connectFuture.cancel(true);
                initFuture.cancel(true);
            }
        });
        connectFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (!future.isSuccess()) {
                logger.debug("Connecting to Redis at {}: {}", (Object)redisAddress, (Object)future.cause());
                connectionBuilder.endpoint().initialState();
                channelReadyFuture.completeExceptionally(future.cause());
                return;
            }
            initFuture.whenComplete((success, throwable) -> {
                if (throwable == null) {
                    logger.debug("Connecting to Redis at {}: Success", (Object)redisAddress);
                    RedisChannelHandler<?, ?> connection = connectionBuilder.connection();
                    connection.registerCloseables(this.closeableResources, connection);
                    channelReadyFuture.complete(connectFuture.channel());
                    return;
                }
                logger.debug("Connecting to Redis at {}, initialization: {}", (Object)redisAddress, throwable);
                connectionBuilder.endpoint().initialState();
                Throwable failure = throwable instanceof RedisConnectionException ? throwable : (throwable instanceof TimeoutException ? new RedisConnectionException("Could not initialize channel within " + connectionBuilder.getTimeout(), (Throwable)throwable) : throwable);
                channelReadyFuture.completeExceptionally(failure);
            });
        }));
    }

    public void shutdown() {
        this.shutdown(0L, 2L, TimeUnit.SECONDS);
    }

    public void shutdown(Duration quietPeriod, Duration timeout) {
        this.shutdown(quietPeriod.toNanos(), timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public void shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        try {
            this.shutdownAsync(quietPeriod, timeout, timeUnit).get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RedisCommandExecutionException) {
                throw ExceptionFactory.createExecutionException(e.getCause().getMessage(), e.getCause());
            }
            throw new RedisException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RedisCommandInterruptedException(e);
        }
        catch (Exception e) {
            throw ExceptionFactory.createExecutionException(null, e);
        }
    }

    public CompletableFuture<Void> shutdownAsync() {
        return this.shutdownAsync(2L, 15L, TimeUnit.SECONDS);
    }

    public CompletableFuture<Void> shutdownAsync(long quietPeriod, long timeout, TimeUnit timeUnit) {
        if (this.shutdown.compareAndSet(false, true)) {
            logger.debug("Initiate shutdown ({}, {}, {})", new Object[]{quietPeriod, timeout, timeUnit});
            return this.closeResources().thenCompose(value -> this.closeClientResources(quietPeriod, timeout, timeUnit));
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> closeResources() {
        ArrayList<CompletableFuture<Void>> closeFutures = new ArrayList<CompletableFuture<Void>>();
        while (!this.closeableResources.isEmpty()) {
            Closeable closeableResource = this.closeableResources.iterator().next();
            if (closeableResource instanceof AsyncCloseable) {
                closeFutures.add(((AsyncCloseable)((Object)closeableResource)).closeAsync());
            } else {
                try {
                    closeableResource.close();
                }
                catch (Exception e) {
                    logger.debug("Exception on Close: " + e.getMessage(), e);
                }
            }
            this.closeableResources.remove(closeableResource);
        }
        for (Channel c : this.channels) {
            ChannelPipeline pipeline = c.pipeline();
            ConnectionWatchdog commandHandler = pipeline.get(ConnectionWatchdog.class);
            if (commandHandler == null) continue;
            commandHandler.setListenOnChannelInactive(false);
        }
        try {
            closeFutures.add(AbstractRedisClient.toCompletableFuture(this.channels.close()));
        }
        catch (Exception e) {
            logger.debug("Cannot close channels", e);
        }
        return Futures.allOf(closeFutures);
    }

    private CompletableFuture<Void> closeClientResources(long quietPeriod, long timeout, TimeUnit timeUnit) {
        ArrayList<CompletableFuture<Void>> groupCloseFutures = new ArrayList<CompletableFuture<Void>>();
        if (!this.sharedResources) {
            Future<Boolean> groupCloseFuture = this.clientResources.shutdown(quietPeriod, timeout, timeUnit);
            groupCloseFutures.add(AbstractRedisClient.toCompletableFuture(groupCloseFuture));
        } else {
            for (EventLoopGroup eventExecutors : this.eventLoopGroups.values()) {
                Future<Boolean> groupCloseFuture = this.clientResources.eventLoopGroupProvider().release(eventExecutors, quietPeriod, timeout, timeUnit);
                groupCloseFutures.add(AbstractRedisClient.toCompletableFuture(groupCloseFuture));
            }
        }
        return Futures.allOf(groupCloseFutures);
    }

    protected int getResourceCount() {
        return this.closeableResources.size();
    }

    protected int getChannelCount() {
        return this.channels.size();
    }

    public void addListener(RedisConnectionStateListener listener) {
        LettuceAssert.notNull((Object)listener, "RedisConnectionStateListener must not be null");
        this.connectionEvents.addListener(listener);
    }

    public void removeListener(RedisConnectionStateListener listener) {
        LettuceAssert.notNull((Object)listener, "RedisConnectionStateListener must not be null");
        this.connectionEvents.removeListener(listener);
    }

    public ClientOptions getOptions() {
        return this.clientOptions;
    }

    protected void setOptions(ClientOptions clientOptions) {
        LettuceAssert.notNull((Object)clientOptions, "ClientOptions must not be null");
        this.clientOptions = clientOptions;
    }

    private static CompletableFuture<Void> toCompletableFuture(Future<?> future) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        if (future.isDone() || future.isCancelled()) {
            if (future.isSuccess()) {
                promise.complete(null);
            } else {
                promise.completeExceptionally(future.cause());
            }
            return promise;
        }
        future.addListener((? extends Future<? super V> f) -> {
            if (f.isSuccess()) {
                promise.complete(null);
            } else {
                promise.completeExceptionally(f.cause());
            }
        });
        return promise;
    }
}

