/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.spring.net.authority;

import com.mugui.spring.base.ManagerInterface;
import com.mugui.spring.base.Module;
import com.mugui.spring.net.authority.Authority;
import com.mugui.spring.net.authority.AuthorityManagerApi;
import com.mugui.spring.net.auto.AutoManager;
import com.mugui.spring.net.classutil.DataSave;
import com.mugui.sql.SqlModel;
import java.util.HashMap;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.rpc.service.GenericService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;

@AutoManager
public class AuthorityInitManager
implements ManagerInterface<String, Object> {
    @Value(value="${mugui.spring.authority.open:false}")
    private boolean isAuthority;
    private Boolean open = null;
    private Boolean byclass = null;
    @Autowired
    private Environment environment;
    private GenericService authorityManagerApi;
    SqlModel sqlModel = null;
    private HashMap<String, Object> map = new HashMap();

    @Override
    public boolean isInit() {
        return false;
    }

    @Override
    public boolean init(Object object) {
        if (!this.isAuthority) {
            return this.isAuthority;
        }
        this.init();
        this.sqlModel = new SqlModel();
        this.readSpringYml();
        if (!this.open.booleanValue()) {
            return this.open;
        }
        if (this.byclass.booleanValue()) {
            this.loadAuthorityByClass((Class)object);
        }
        return false;
    }

    private void init() {
        if (this.authorityManagerApi == null) {
            ReferenceConfig referenceConfig = new ReferenceConfig();
            referenceConfig.setVersion("");
            referenceConfig.setInterface(AuthorityManagerApi.class);
            referenceConfig.setGroup("default");
            referenceConfig.setGeneric(true);
            this.authorityManagerApi = (GenericService)referenceConfig.get();
        }
    }

    private void readSpringYml() {
        if (this.open == null) {
            try {
                this.open = this.environment.getProperty("mugui.spring.authority.open", Boolean.class);
                if (this.open == null) {
                    this.open = false;
                }
                this.byclass = this.environment.getProperty("mugui.spring.authority.byclass", Boolean.class);
                if (this.byclass == null) {
                    this.byclass = false;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                this.open = false;
                this.byclass = false;
                throw new RuntimeException("\u8bfb\u53d6Authority \u914d\u7f6e\u9519\u8bef", e1);
            }
        }
    }

    private void loadAuthorityByClass(Class<?> object) {
        this.authorityManagerApi.$invoke("init", new String[]{String.class.getName()}, new Object[1]);
        for (Class<?> class_name : DataSave.initClassList(object)) {
            if (!class_name.isAnnotationPresent(Authority.class)) continue;
            Authority annotation = class_name.getAnnotation(Authority.class);
            boolean annotationPresent = class_name.isAnnotationPresent(Module.class);
            if (!annotationPresent) {
                throw new RuntimeException("\u6b64\u6ce8\u89e3\u662fModule \u6ce8\u89e3\u7684\u8865\u5145\u6ce8\u89e3\uff0c\u9700\u6ce8\u89e3\u5728Module\u4e0b");
            }
            Module annotation2 = class_name.getAnnotation(Module.class);
            String key = String.valueOf(annotation2.name()) + "." + annotation2.type() + ".*";
            this.authorityManagerApi.$invoke("addAuthority", new String[]{String.class.getName(), Boolean.class.getName()}, new Object[]{key, annotation.value()});
        }
    }

    @Override
    public boolean is(String key) {
        return false;
    }

    @Override
    public boolean clear() {
        return false;
    }

    @Override
    @Deprecated
    public Object del(String key) {
        return null;
    }

    @Override
    public Object get(String key) {
        return null;
    }

    @Override
    public boolean add(String key, Object value) {
        return false;
    }
}

