/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingMaintainService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.api.selector.ExpressionSelector;
import com.alibaba.nacos.api.selector.NoneSelector;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.alibaba.nacos.client.naming.utils.InitUtils;
import com.alibaba.nacos.client.utils.StringUtils;
import java.util.Map;
import java.util.Properties;

public class NacosNamingMaintainService
implements NamingMaintainService {
    private String namespace;
    private String endpoint;
    private String serverList;
    private NamingProxy serverProxy;

    public NacosNamingMaintainService(String serverList) {
        Properties properties = new Properties();
        properties.setProperty("serverAddr", serverList);
        this.init(properties);
    }

    public NacosNamingMaintainService(Properties properties) {
        this.init(properties);
    }

    private void init(Properties properties) {
        this.namespace = InitUtils.initNamespaceForNaming(properties);
        this.initServerAddr(properties);
        InitUtils.initWebRootContext();
        this.serverProxy = new NamingProxy(this.namespace, this.endpoint, this.serverList);
        this.serverProxy.setProperties(properties);
    }

    private void initServerAddr(Properties properties) {
        this.serverList = properties.getProperty("serverAddr");
        this.endpoint = InitUtils.initEndpoint(properties);
        if (StringUtils.isNotEmpty(this.endpoint)) {
            this.serverList = "";
        }
    }

    @Override
    public void updateInstance(String serviceName, Instance instance) throws NacosException {
        this.updateInstance(serviceName, "DEFAULT_GROUP", instance);
    }

    @Override
    public void updateInstance(String serviceName, String groupName, Instance instance) throws NacosException {
        this.serverProxy.updateInstance(serviceName, groupName, instance);
    }

    @Override
    public Service queryService(String serviceName) throws NacosException {
        return this.queryService(serviceName, "DEFAULT_GROUP");
    }

    @Override
    public Service queryService(String serviceName, String groupName) throws NacosException {
        return this.serverProxy.queryService(serviceName, groupName);
    }

    @Override
    public void createService(String serviceName) throws NacosException {
        this.createService(serviceName, "DEFAULT_GROUP");
    }

    @Override
    public void createService(String serviceName, String groupName) throws NacosException {
        this.createService(serviceName, groupName, 0.0f);
    }

    @Override
    public void createService(String serviceName, String groupName, float protectThreshold) throws NacosException {
        NoneSelector selector = new NoneSelector();
        Service service = new Service();
        service.setName(serviceName);
        service.setGroupName(groupName);
        service.setProtectThreshold(protectThreshold);
        this.createService(service, selector);
    }

    @Override
    public void createService(String serviceName, String groupName, float protectThreshold, String expression) throws NacosException {
        Service service = new Service();
        service.setName(serviceName);
        service.setGroupName(groupName);
        service.setProtectThreshold(protectThreshold);
        ExpressionSelector selector = new ExpressionSelector();
        selector.setExpression(expression);
        this.createService(service, selector);
    }

    @Override
    public void createService(Service service, AbstractSelector selector) throws NacosException {
        this.serverProxy.createService(service, selector);
    }

    @Override
    public boolean deleteService(String serviceName) throws NacosException {
        return this.deleteService(serviceName, "DEFAULT_GROUP");
    }

    @Override
    public boolean deleteService(String serviceName, String groupName) throws NacosException {
        return this.serverProxy.deleteService(serviceName, groupName);
    }

    @Override
    public void updateService(String serviceName, String groupName, float protectThreshold) throws NacosException {
        Service service = new Service();
        service.setName(serviceName);
        service.setGroupName(groupName);
        service.setProtectThreshold(protectThreshold);
        this.updateService(service, new NoneSelector());
    }

    @Override
    public void updateService(String serviceName, String groupName, float protectThreshold, Map<String, String> metadata) throws NacosException {
        Service service = new Service();
        service.setName(serviceName);
        service.setGroupName(groupName);
        service.setProtectThreshold(protectThreshold);
        service.setMetadata(metadata);
        this.updateService(service, new NoneSelector());
    }

    @Override
    public void updateService(Service service, AbstractSelector selector) throws NacosException {
        this.serverProxy.updateService(service, selector);
    }
}

