package com.mugui.bean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Map;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer;

public class JsonBeanDeserializer extends JavaBeanDeserializer {
	public JsonBeanDeserializer(Class<?> class1) {
		this(ParserConfig.getGlobalInstance(), class1);
	}

	public JsonBeanDeserializer(ParserConfig config, Class<?> clazz) {
		super(config, clazz);
	}

	@Override
	public Object createInstance(Map<String, Object> map, ParserConfig config)
			throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
		if (map.isEmpty()) {
			return null;
		}
		Object createInstance = super.createInstance(map, config);
		if (createInstance instanceof JsonBean) {
			JsonBean bean = (JsonBean) createInstance;
			bean.get().putAll(map);
		}
		return createInstance;
	}

	@Override
	public Object createInstance(DefaultJSONParser parser, Type type) {
		return super.createInstance(parser, type);
	}

}
