/*
 * Decompiled with CFR 0.152.
 */
package cn.net.clink.scrati.entity;

public enum OSPlatform {
    Android(1),
    IOS(2),
    Web(4),
    AndroidWeb(5),
    IOSWeb(6);

    private int value;

    private OSPlatform(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static OSPlatform fromString(String osPlatform) {
        if (osPlatform == null || "".equals(osPlatform)) {
            return null;
        }
        switch (osPlatform) {
            case "Android": {
                return Android;
            }
            case "IOS": {
                return IOS;
            }
            case "Web": {
                return Web;
            }
            case "AndroidWeb": {
                return AndroidWeb;
            }
            case "IOSWeb": {
                return IOSWeb;
            }
        }
        return null;
    }

    public static boolean containsAndroid(String osPlatform) {
        OSPlatform osPlatform_ = OSPlatform.fromString(osPlatform);
        if (osPlatform_ == null) {
            return false;
        }
        return Android.getValue() == (osPlatform_.getValue() & Android.getValue());
    }

    public static boolean containsIOS(String osPlatform) {
        OSPlatform osPlatform_ = OSPlatform.fromString(osPlatform);
        if (osPlatform_ == null) {
            return false;
        }
        return IOS.getValue() == (osPlatform_.getValue() & IOS.getValue());
    }

    public static boolean containsWeb(String osPlatform) {
        OSPlatform osPlatform_ = OSPlatform.fromString(osPlatform);
        if (osPlatform_ == null) {
            return false;
        }
        return Web.getValue() == (osPlatform_.getValue() & Web.getValue());
    }

    public static boolean isAndroid(String osPlatform) {
        return Android.equals((Object)OSPlatform.fromString(osPlatform));
    }

    public static boolean isIOS(String osPlatform) {
        return IOS.equals((Object)OSPlatform.fromString(osPlatform));
    }

    public static boolean isWeb(String osPlatform) {
        return Web.equals((Object)OSPlatform.fromString(osPlatform));
    }

    public static boolean isAndroidWeb(String osPlatform) {
        return AndroidWeb.equals((Object)OSPlatform.fromString(osPlatform));
    }

    public static boolean isIOSWeb(String osPlatform) {
        return IOSWeb.equals((Object)OSPlatform.fromString(osPlatform));
    }

    public static boolean isValid(String osPlatform) {
        return OSPlatform.fromString(osPlatform) != null;
    }
}

