/*
 * Decompiled with CFR 0.152.
 */
package cn.net.clink.scrati;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class UrlParamUtil {
    private static final Logger logger = Logger.getLogger(UrlParamUtil.class);

    public static String createLinkString(Map<String, ? extends Object> params) {
        return UrlParamUtil.createLinkString(params, false);
    }

    public static String createLinkString(Map<String, ? extends Object> params, Boolean encodeValue) {
        if (params == null || params.size() == 0) {
            return "";
        }
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuffer linkString = new StringBuffer();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            Object value = params.get(key);
            if (UrlParamUtil.isEmpty(value)) continue;
            if (encodeValue.booleanValue()) {
                try {
                    value = URLEncoder.encode(value.toString(), "UTF-8");
                }
                catch (Throwable th) {
                    continue;
                }
            }
            if (linkString.length() > 0) {
                linkString.append("&");
            }
            linkString.append(key).append("=").append(value);
        }
        return linkString.toString();
    }

    public static Map<String, String> fromLinkString(String linkString) {
        return UrlParamUtil.fromLinkString(linkString, Boolean.FALSE);
    }

    public static Map<String, String> fromLinkString(String linkString, Boolean decodeValue) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        try {
            String[] params;
            if (!UrlParamUtil.isEmpty(linkString) && (params = linkString.split("&")) != null && params.length > 0) {
                for (String param : params) {
                    String[] kv;
                    if (UrlParamUtil.isEmpty(param) || !param.contains("=") || (kv = param.split("=")) == null || kv.length != 2) continue;
                    String value = decodeValue != false ? URLDecoder.decode(kv[1], "UTF-8") : kv[1];
                    paramsMap.put(kv[0], value);
                }
            }
        }
        catch (Throwable th) {
            logger.error((Object)("<<<<<< Parse Url(" + linkString + ") To Map On Error"), th);
        }
        return paramsMap;
    }

    private static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return "".equals(str);
        }
        return false;
    }

    private static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }
}

