/*
 * Decompiled with CFR 0.152.
 */
package cn.net.clink.scrati;

import cn.net.clink.scrati.AESUtil;
import cn.net.clink.scrati.HttpClientProvider;
import cn.net.clink.scrati.RSAUtil;
import cn.net.clink.scrati.ScratiConfig;
import cn.net.clink.scrati.ScratiException;
import cn.net.clink.scrati.UrlParamUtil;
import cn.net.clink.scrati.entity.ScratiCommonReq;
import cn.net.clink.scrati.entity.ScratiCommonResp;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class Scrati {
    private static final Logger logger = Logger.getLogger(Scrati.class);
    private boolean debug = false;
    private static final Scrati scrati = new Scrati();
    private ScratiConfig scratiConfig;
    private HttpClientProvider httpClientProvider = new HttpClientProvider();

    private Scrati() {
    }

    public static Scrati getInstance() {
        return scrati;
    }

    public <T extends ScratiCommonResp> T execute(String service, ScratiCommonReq scratiCommonReq, Class<T> clazz) throws ScratiException {
        this.validate(service, scratiCommonReq, clazz);
        return (T)((ScratiCommonResp)JSON.parseObject((String)this.executeAndDecryptBizContent(service, scratiCommonReq), clazz));
    }

    public <T extends ScratiCommonResp> List<T> executeList(String service, ScratiCommonReq scratiCommonReq, Class<T> clazz) throws ScratiException {
        this.validate(service, scratiCommonReq, clazz);
        return JSON.parseArray((String)this.executeAndDecryptBizContent(service, scratiCommonReq), clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String executeAndDecryptBizContent(String method, ScratiCommonReq scratiCommonReq) throws ScratiException {
        HttpPost httpPost = null;
        CloseableHttpResponse response = null;
        try {
            JSONObject respJsonObj;
            String reqJson = JSON.toJSONString((Object)scratiCommonReq);
            if (this.debug) {
                logger.info((Object)("< ScratiSdk Request Biz Data:\r\n" + reqJson + "\r\n"));
            }
            String encryptData = AESUtil.encryptToHex(this.scratiConfig.getAesKey(), reqJson);
            HashMap<String, String> request = new HashMap<String, String>();
            request.put("org", this.scratiConfig.getOrg());
            request.put("method", method);
            request.put("traceId", UUID.randomUUID().toString().replaceAll("-", ""));
            request.put("timestamp", System.currentTimeMillis() + "");
            request.put("request", encryptData);
            request.put("sign", RSAUtil.signToBase64(UrlParamUtil.createLinkString(request).getBytes(), this.scratiConfig.getPartnerPrivateKey(), "SHA1WithRSA"));
            String requestJson = JSON.toJSONString(request);
            if (this.debug) {
                logger.info((Object)("< ScratiSdk Request:\r\n" + requestJson));
            }
            httpPost = this.httpClientProvider.getHttpPost(this.scratiConfig.getGatewayUrl());
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setEntity((HttpEntity)new StringEntity(requestJson, Charset.forName("UTF-8")));
            response = this.httpClientProvider.getHttpClient().execute((HttpUriRequest)httpPost);
            if (200 != response.getStatusLine().getStatusCode()) throw new ScratiException("999999", "\u670d\u52a1\u8c03\u7528\u5931\u8d25(StatusCode=" + response.getStatusLine().getStatusCode() + ")");
            String respStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            if (this.debug) {
                logger.info((Object)("< ScratiSdk Response:\r\n" + respStr));
            }
            if (!"000000".equals((respJsonObj = JSON.parseObject((String)respStr)).getString("rstCode"))) {
                throw new ScratiException(respJsonObj.getString("rstCode"), respJsonObj.getString("rstMsg"));
            }
            String respSign = respJsonObj.getString("sign");
            respJsonObj.remove((Object)"sign");
            if (!RSAUtil.verifyFromBase64Sign(UrlParamUtil.createLinkString((Map<String, ? extends Object>)respJsonObj).getBytes(), respSign, this.scratiConfig.getPlatformPublicKey(), "SHA1WithRSA")) {
                throw new ScratiException("999999", "\u8fd4\u56de\u62a5\u6587\u9a8c\u7b7e\u5931\u8d25");
            }
            try {
                String respJson = AESUtil.decryptFromHex(this.scratiConfig.getAesKey(), respJsonObj.getString("encryptData"));
                if (this.debug) {
                    logger.info((Object)("< ScratiSdk Response Biz Data:\r\n" + respJson));
                }
                String string = respJson;
                return string;
            }
            catch (Throwable th) {
                try {
                    logger.info((Object)("< ScratiSdk Response:\r\n" + respStr), th);
                    throw new ScratiException("999999", "\u8fd4\u56de\u62a5\u6587\u89e3\u5bc6\u5931\u8d25", th);
                }
                catch (ScratiException ex) {
                    throw ex;
                }
                catch (Throwable th2) {
                    logger.error((Object)"< Call Scrati Service On Error", th2);
                    throw new ScratiException("999999", "\u670d\u52a1\u8c03\u7528\u5931\u8d25", th2);
                }
            }
        }
        finally {
            if (httpPost != null) {
                try {
                    httpPost.releaseConnection();
                }
                catch (Throwable throwable) {}
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void validate(String method, ScratiCommonReq scratiCommonReq, Class clazz) throws ScratiException {
        if (this.scratiConfig == null) {
            throw new ScratiException("400000", "SDK\u53c2\u6570\u672a\u521d\u59cb\u5316");
        }
        if (this.scratiConfig.getOrg() == null || "".equals(this.scratiConfig.getOrg().trim())) {
            throw new ScratiException("400000", "\u5408\u4f5c\u65b9\u673a\u6784\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.scratiConfig.getAesKey() == null || "".equals(this.scratiConfig.getAesKey().trim())) {
            throw new ScratiException("400000", "\u5408\u4f5c\u65b9\u52a0\u89e3\u5bc6\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.scratiConfig.getAesKey().length() != 16) {
            throw new ScratiException("400000", "\u5408\u4f5c\u65b9\u52a0\u89e3\u5bc6\u5bc6\u94a5\u957f\u5ea6\u9519\u8bef");
        }
        if (this.scratiConfig.getPartnerPrivateKey() == null || "".equals(this.scratiConfig.getPartnerPrivateKey().trim())) {
            throw new ScratiException("400000", "\u5408\u4f5c\u65b9\u7b7e\u540d\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.scratiConfig.getPlatformPublicKey() == null || "".equals(this.scratiConfig.getPlatformPublicKey().trim())) {
            throw new ScratiException("400000", "\u5e73\u53f0\u65b9\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.scratiConfig.getGatewayUrl() == null || "".equals(this.scratiConfig.getGatewayUrl().trim())) {
            throw new ScratiException("400000", "\u5e73\u53f0\u63a5\u5165\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (method == null || "".equals(method.trim())) {
            throw new ScratiException("400000", "\u65b9\u6cd5\u670d\u52a1\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (scratiCommonReq == null) {
            throw new ScratiException("400000", "\u8bf7\u6c42\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (clazz == null) {
            throw new ScratiException("400000", "clazz\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setConfig(ScratiConfig scratiConfig) {
        this.scratiConfig = scratiConfig;
    }

    public ScratiConfig getConfig() {
        return this.scratiConfig;
    }
}

