/*
 * Decompiled with CFR 0.152.
 */
package cn.net.clink.scrati;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class RSAUtil {
    private static final Logger logger = Logger.getLogger(RSAUtil.class);

    public static String signToBase64(byte[] data, String privateKey, String algorithm) {
        byte[] signData = RSAUtil.sign(data, privateKey, algorithm);
        try {
            return RSAUtil.encodeBase64(signData);
        }
        catch (Throwable th) {
            logger.warn((Object)("<<< Encode Base64 Fail(" + signData + ")"));
            return null;
        }
    }

    private static byte[] sign(byte[] data, String privateKey, String algorithm) {
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(RSAUtil.getPrivateKey(privateKey));
            signature.update(data);
            return signature.sign();
        }
        catch (Throwable th) {
            logger.warn((Object)"<<< RSA Sign Data Fail", th);
            try {
                logger.warn((Object)("<<< Base64Data=" + RSAUtil.encodeBase64(data)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }

    public static boolean verifyFromBase64Sign(byte[] data, String sign, String publicKey, String algorithm) {
        try {
            return RSAUtil.verifySign(data, RSAUtil.decodeBase64(sign), publicKey, algorithm);
        }
        catch (Throwable th) {
            logger.warn((Object)("<<< Decode Base64 Fail(" + sign + ")"));
            return false;
        }
    }

    private static boolean verifySign(byte[] data, byte[] signData, String publicKey, String algorithm) {
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initVerify(RSAUtil.getPublicKey(publicKey));
            signature.update(data);
            return signature.verify(signData);
        }
        catch (Throwable th) {
            logger.warn((Object)"<<< RSA Verify Sign Fail", th);
            try {
                logger.warn((Object)("<<< Base64Data=" + RSAUtil.encodeBase64(data)));
                logger.warn((Object)("<<< Base64Sign=" + RSAUtil.encodeBase64(signData)));
                logger.warn((Object)("<<< PublicKey=" + publicKey));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
    }

    private static PublicKey getPublicKey(String key) throws Exception {
        X509EncodedKeySpec pubX509 = new X509EncodedKeySpec(RSAUtil.decodeBase64(key));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(pubX509);
    }

    private static PrivateKey getPrivateKey(String key) throws Exception {
        PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(RSAUtil.decodeBase64(key));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(priPKCS8);
    }

    private static String encodeBase64(byte[] input) throws Exception {
        return Base64.encodeBase64String((byte[])input);
    }

    private static byte[] decodeBase64(String input) throws Exception {
        return Base64.decodeBase64((String)input);
    }
}

