/*
 * Decompiled with CFR 0.152.
 */
package cn.net.clink.scrati;

import cn.net.clink.scrati.IdleConnectionCleanThread;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.log4j.Logger;

class HttpClientProvider {
    private static final Logger logger = Logger.getLogger(HttpClientProvider.class);
    private CloseableHttpClient httpClient;
    private PoolingHttpClientConnectionManager connManager;

    public HttpClientProvider() {
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            });
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build(), new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.2"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry registry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("https", (Object)sslsf).build();
            this.connManager = new PoolingHttpClientConnectionManager(registry);
            this.connManager.setMaxTotal(500);
            this.connManager.setDefaultMaxPerRoute(500);
            this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connManager).build();
            new IdleConnectionCleanThread((HttpClientConnectionManager)this.connManager);
        }
        catch (Throwable th) {
            logger.error((Object)"<<<<<< Init Http Executor On Error", th);
        }
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpPost getHttpPost(String url) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(15000).setSocketTimeout(45000).build());
        return httpPost;
    }
}

