/*
 * Decompiled with CFR 0.152.
 */
package cn.net.clink.scrati;

import cn.net.clink.scrati.HexUtil;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class AESUtil {
    private static final Logger logger = Logger.getLogger(AESUtil.class);
    private static final String DEFAULT_ALGORITHM = "AES/ECB/PKCS5Padding";

    public static final String encryptToHex(String key, String data) {
        return AESUtil.encryptToHex(key, data, DEFAULT_ALGORITHM);
    }

    public static final String encryptToHex(String key, String data, String algorithm) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(1, keySpec);
            return HexUtil.byte2hex(cipher.doFinal(data.getBytes()));
        }
        catch (Throwable th) {
            logger.warn((Object)("AES EncryptToHex Fail With Key=" + key + ", Data=" + data), th);
            return null;
        }
    }

    public static final String decryptFromHex(String key, String data) {
        return AESUtil.decryptFromHex(key, data, DEFAULT_ALGORITHM);
    }

    public static final String decryptFromHex(String key, String data, String algorithm) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(2, keySpec);
            return new String(cipher.doFinal(HexUtil.hex2byte(data)));
        }
        catch (Throwable th) {
            logger.warn((Object)("AES DecryptFromHex Fail With Key=" + key + ", Data=" + data), th);
            return null;
        }
    }
}

