/*
 * Decompiled with CFR 0.152.
 */
package cn.net.clink.scrati.entity;

import java.util.regex.Pattern;

public class PayChannels {
    public static final PayChannel WEIXIN_PAY = new PayChannel("\u5fae\u4fe1\u652f\u4ed8", "WEIXIN_PAY", 1, 18, "13");
    public static final PayChannel ALI_PAY = new PayChannel("\u652f\u4ed8\u5b9d", "ALIPAY", 2, 18, "28");
    public static final PayChannel UNION_PAY = new PayChannel("\u94f6\u8054\u94b1\u5305", "UNION_PAY", 4, 21, "1010");
    public static final PayChannel TEN_PAY = new PayChannel("QQ\u94b1\u5305", "TEN_PAY", 8, 18, "91");
    public static final PayChannel BAIDU_WALLET = new PayChannel("\u767e\u5ea6\u94b1\u5305", "BAIDU_PAY", 16, 18, "31");
    public static final PayChannel JD_PAY = new PayChannel("\u4eac\u4e1c\u94b1\u5305", "JD_PAY", 32, 18, "18");
    public static final PayChannel QUICK_PAY = new PayChannel("\u5feb\u6377\u652f\u4ed8", "QUICK_PAY", 64, null, null);
    public static final PayChannel ADVANCE = new PayChannel("\u4ee3\u4ed8", "ADVANCE", 128, null, null);
    public static final PayChannel GATEWAY = new PayChannel("\u7f51\u5173\u652f\u4ed8", "GATEWAY", 256, null, null);
    public static final PayChannel UNION_ONLINE = new PayChannel("\u94f6\u8054\u5728\u7ebf", "UNION_ONLINE", 512, null, null);

    public static void main(String[] args) {
        long value = UNION_PAY.value | ADVANCE.value;
        System.out.println(value);
    }

    public static PayChannel fromAuthCode(String authCode) {
        if (authCode != null && !"".equals(authCode)) {
            if (WEIXIN_PAY.checkPayCode(authCode)) {
                return WEIXIN_PAY;
            }
            if (ALI_PAY.checkPayCode(authCode)) {
                return ALI_PAY;
            }
            if (UNION_PAY.checkPayCode(authCode)) {
                return UNION_PAY;
            }
            if (TEN_PAY.checkPayCode(authCode)) {
                return TEN_PAY;
            }
            if (BAIDU_WALLET.checkPayCode(authCode)) {
                return BAIDU_WALLET;
            }
            if (JD_PAY.checkPayCode(authCode)) {
                return JD_PAY;
            }
            if (UNION_ONLINE.checkPayCode(authCode)) {
                return UNION_ONLINE;
            }
        }
        return null;
    }

    public static PayChannel fromString(String code) {
        if (code == null || "".equals(code)) {
            return null;
        }
        switch (code) {
            case "WEIXIN_PAY": {
                return WEIXIN_PAY;
            }
            case "ALIPAY": {
                return ALI_PAY;
            }
            case "UNION_PAY": {
                return UNION_PAY;
            }
            case "TEN_PAY": {
                return TEN_PAY;
            }
            case "BAIDU_PAY": {
                return BAIDU_WALLET;
            }
            case "JD_PAY": {
                return JD_PAY;
            }
            case "QUICK_PAY": {
                return QUICK_PAY;
            }
            case "ADVANCE": {
                return ADVANCE;
            }
            case "GATEWAY": {
                return GATEWAY;
            }
            case "UNION_ONLINE": {
                return UNION_ONLINE;
            }
        }
        return null;
    }

    public static PayChannel fromValue(Integer value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return WEIXIN_PAY;
            }
            case 2: {
                return ALI_PAY;
            }
            case 4: {
                return UNION_PAY;
            }
            case 8: {
                return TEN_PAY;
            }
            case 16: {
                return BAIDU_WALLET;
            }
            case 32: {
                return JD_PAY;
            }
            case 64: {
                return QUICK_PAY;
            }
            case 128: {
                return ADVANCE;
            }
            case 256: {
                return GATEWAY;
            }
            case 512: {
                return UNION_ONLINE;
            }
        }
        return null;
    }

    public static class PayChannel {
        private String name;
        private String code;
        private Integer value;
        private Integer payCodeLength;
        private String payCodeStartsWith;

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PayChannel that = (PayChannel)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public PayChannel() {
        }

        public PayChannel(String name, String code, Integer value, Integer payCodeLength, String payCodeStartsWith) {
            this.name = name;
            this.code = code;
            this.value = value;
            this.payCodeLength = payCodeLength;
            this.payCodeStartsWith = payCodeStartsWith;
        }

        public boolean checkPayCode(String payCode) {
            if (this.payCodeLength == null || this.payCodeStartsWith == null || "".equals(this.payCodeStartsWith)) {
                return false;
            }
            if (!PayChannel.isSpecNumber(payCode, this.payCodeLength) && !PayChannel.isSpecNumber(payCode, 17)) {
                return false;
            }
            return payCode.startsWith(this.payCodeStartsWith);
        }

        private static boolean isSpecNumber(String str, int specLen) {
            if (str == null || "".equals(str)) {
                return false;
            }
            Pattern pattern = Pattern.compile("^[0-9]{" + specLen + "}$");
            return pattern.matcher(str).matches();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public Integer getValue() {
            return this.value;
        }

        public void setValue(Integer value) {
            this.value = value;
        }

        public Integer getPayCodeLength() {
            return this.payCodeLength;
        }

        public void setPayCodeLength(Integer payCodeLength) {
            this.payCodeLength = payCodeLength;
        }

        public String getPayCodeStartsWith() {
            return this.payCodeStartsWith;
        }

        public void setPayCodeStartsWith(String payCodeStartsWith) {
            this.payCodeStartsWith = payCodeStartsWith;
        }
    }
}

